<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
$referencia = $_GET['referencia'];

$sqlpro = "SELECT * FROM producto WHERE referencia='$referencia'";
$querypro = $conn->query($sqlpro);
$rowpro = $querypro->fetch_assoc();
?> 
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="producto.php"> 
                                    Productos             
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $referencia; ?></li>
                            <li class="breadcrumb-item active" aria-current="page">Novedad</li>
                        </ol>
                    </nav>


                    <div class="card card-table mb-3">
                        <div class="card-header">
                            <h4 >Novedad: <strong class="text-titulo"><?php echo $referencia; ?></strong></h4>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-3"> 
                                <div class="col-12 col-md-12">
                                    <div class="row"> 
                                        <div class="col-12 col-sm-2 mt-2 ">
                                            <a class="btn btn-outline-dark px-5 radius-30 w-100" href="kardex.php?referencia=<?php echo $referencia; ?>">
                                                <i class="far fa-chart-bar opacity-5 me-2 text-titulo" ></i> Kardex        
                                            </a>
                                        </div>
                                        <div class="col-12 col-sm-2 mt-2">
                                            <a class="btn btn-outline-dark px-5 radius-30 w-100" href="talla.php?referencia=<?php echo $referencia; ?>">
                                                <i class="fas fa-tags opacity-5 me-2 text-titulo" ></i> Tallas        
                                            </a>
                                        </div>
                                        <div class="col-12 col-sm-2 mt-2">
                                            <a class="btn btn-dark px-5 radius-30 w-100" href="novedad.php?referencia=<?php echo $referencia; ?>">
                                                <i class="fas fa-file-signature opacity-5 me-2 text-titulo" ></i> Novedad        
                                            </a>
                                        </div>
                                        <div class="col-12 col-sm-2 mt-2">
                                            <a class="btn btn-outline-dark px-5 radius-30 w-100" href="devolucion.php?referencia=<?php echo $referencia; ?>">
                                                <i class="fas fa-boxes-packing opacity-5 me-2 text-titulo" ></i> Devolucion        
                                            </a>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row"> 
                                <div class="col-12 col-md-4 col-lg-3">
                                    <table class="table text-sm table-sm" >
                                        <thead>
                                            <tr>
                                                <th class=" p-2">Habilitado</th>
                                                <th class=" p-2"> 
                                                    <?php
                                                    if ($rowpro['habilitado'] == 'Si') {
                                                        ?>
                                                        <span class="badge alert-success"><?php echo $rowpro['habilitado']; ?></span>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <span class="badge alert-danger"><?php echo $rowpro['habilitado']; ?></span>

                                                        <?php
                                                    }
                                                    ?>
                                                </th>
                                            </tr>
                                            <tr>
                                                <th class=" p-2">Color</th>
                                                <td class=""><?php echo $rowpro['color']; ?></td>
                                            </tr>                                   
                                            <tr>
                                                <th class=" p-2">Categoria</th>
                                                <td class=""><?php echo $rowpro['categoria']; ?></td>
                                            </tr>
                                            <tr>
                                                <th class=" p-2">Clase</th>
                                                <td class=""><?php echo $rowpro['clase']; ?></td>
                                            </tr>
                                            <tr>
                                                <th class=" p-2">Peso</th>
                                                <td class=""><?php echo $rowpro['peso']; ?> g</td>
                                            </tr>
                                            <tr>
                                                <th class=" p-2">Precio de venta</th>
                                                <td class=""> <b class="text-secondary">$</b> <?php echo number_format($rowpro['precio_venta']); ?></td>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>


                                <div class="col-12 col-sm-9">

                                    <div class="card-header-more  text-end mb-2">
                                        <div class="">
                                            <a href="#!" class="btn btn-primary px-5 radius-30 " data-bs-toggle="modal" data-bs-target="#exampleModal" >
                                                Registrar novedad
                                            </a>
                                        </div>
                                    </div>

                                    <!-- Modal -->
                                    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-sm">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title card-heading" id="exampleModalLabel">Registro de novedad</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class=" g-3 needs-validation" method="POST" action="script/novedad-guardar.php">
                                                    <input type="text" required="" name="referencia" value="<?php echo $referencia; ?>" hidden>
                                                    <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>

                                                    <div class="modal-body ">
                                                        <div class="row ">
                                                            <div class="col-md-12">
                                                                <label class="form-label" for="validationCustom01">Fecha</label>
                                                                <input class="form-control" id="validationCustom01" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, seleccione una fecha.</div>
                                                            </div>
                                                            <div class="col-md-6 mt-3">
                                                                <label class="form-label" for="validationCustom02">Talla</label>
                                                                <select class="form-select " id="validationCustom04" required="" name="talla">
                                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                                    <?php
                                                                    for ($i = 10; $i < 50; $i++) {
                                                                        ?>
                                                                        <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                                        <?php
                                                                    }
                                                                    ?>
                                                                </select>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione una talla.</div>
                                                            </div>
                                                            <div class="col-md-6 mt-3">
                                                                <label class="form-label" for="validationCustomUsername">Cantidad</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required="" name="cantidad">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Digite la cantidad de prendas.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3" hidden="">
                                                                <label class="form-label" for="validationCustom02">Tipo</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required=""  name="tipo" value="Normal" readonly="">

                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione el tipo de prenda.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Observacion</label>
                                                                <textarea class="form-control" id="validationCustom02" type="text" required=""  name="observacion">No aplica</textarea>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Digite una descripcion.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Movimiento</label>
                                                                <select class="form-select" id="validationCustom04" required="" name="movimiento">
                                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                                    <option  value="Salida">Salida</option>
                                                                    <option  value="Entrada">Entrada</option> 
                                                                </select>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, Seleccione el movimiento que desea hacer.</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary  radius-30" data-bs-dismiss="modal">Cancelar</button>
                                                        <button type="submit" class="btn btn-primary  radius-30" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>




                                    <h5><b>Lista de novedades</b></h5>
                                    <hr>
                                    <div class="table-responsive">
                                        <table class="table table-hover text-sm table-sm table-bordered table-striped" >
                                            <thead>
                                                <tr>
                                                    <th class=" p-1">Fecha</th>
                                                    <th class="text-center p-1">Talla</th>
                                                    <th class="text-center p-1">Cantidad</th>
                                                    <th class=" p-1">Descripción</th>
                                                    <th class="text-center p-1">Movimiento</th>
                                                    <th class="text-center p-1">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql3 = "SELECT * FROM novedad WHERE  referencia_producto='$referencia'  AND tipo_novedad!='Devolucion' ";
                                                $query3 = $conn->query($sql3);
                                                if ($query3->num_rows > 0) {
                                                    while ($row3 = $query3->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td class="text-center"><?php echo $row3['fecha'] ?></td>
                                                            <td class="text-center">
                                                                <strong>T - <?php echo $row3['talla']; ?></strong>
                                                            </td>
                                                            <td class="text-center"><?php echo $row3['cantidad']; ?></td>
                                                            <td class=""><?php echo $row3['observacion']; ?></td>
                                                            <td class="text-center">
                                                                <?php if ($row3['movimiento'] == 'Salida') { ?>
                                                                    <span class="badge alert-danger"><?php echo $row3['movimiento']; ?></span>
                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <span class="badge alert-success"><?php echo $row3['movimiento']; ?></span>

                                                                    <?php
                                                                }
                                                                ?>
                                                            </td>

                                                            <td class="text-center">


                                                                <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#editar<?php echo $row3['id'] ?>">
                                                                    <i class="far fa-edit opacity-5 me-2 text-warning"></i>
                                                                </a>

                                                                <div class="modal fade text-start" id="editar<?php echo $row3['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-sm">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Editar movimiento</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/novedad-editar.php">
                                                                                <input  type="text" required="" name="edit_id" value="<?php echo $row3['id']; ?>"  hidden>
                                                                                <input type="text" required="" name="edit_referencia" value="<?php echo $referencia; ?>" hidden>
                                                                                <input type="text" required="" name="edit_nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>

                                                                                <div class="modal-body ">
                                                                                    <div class="row ">
                                                                                        <div class="col-md-12">
                                                                                            <label class="form-label" for="validationCustom01">Fecha</label>
                                                                                            <input class="form-control"  type="date" required="" name="edit_fecha" value="<?php echo $row3['fecha']; ?>">
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, seleccione una fecha.</div>
                                                                                        </div>


                                                                                        <div class="col-md-6 mt-3">
                                                                                            <label class="form-label" for="validationCustom02">Talla</label>
                                                                                            <select class="form-select "  required="" name="edit_talla" >
                                                                                                <option selected value="<?php echo $row3['talla']; ?>"><?php echo $row3['talla']; ?></option>
                                                                                                <option disabled="" value="">Seleccione</option>
                                                                                                <?php
                                                                                                for ($i = 10; $i < 50; $i++) {
                                                                                                    ?>
                                                                                                    <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                                                                    <?php
                                                                                                }
                                                                                                ?>
                                                                                            </select>
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Seleccione una talla.</div>
                                                                                        </div>
                                                                                        <div class="col-md-6 mt-3">
                                                                                            <label class="form-label" for="validationCustomUsername">Cantidad</label>
                                                                                            <input class="form-control"  type="text" required="" name="edit_cantidad" id="edit_cantidad" value="<?php echo $row3['cantidad']; ?>">
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Digite la cantidad de prendas.</div>
                                                                                        </div>
                                                                                        <div class="col-md-12 mt-3">
                                                                                            <label class="form-label" for="validationCustom02">Descripcion</label>
                                                                                            <textarea class="form-control"  type="text" required=""  name="edit_observacion" id="edit_observacion"><?php echo $row3['observacion']; ?></textarea>
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Digite una descripcion.</div>
                                                                                        </div>

                                                                                        <div class="col-md-12 mt-3">
                                                                                            <label class="form-label" for="validationCustom02">Movimiento</label>
                                                                                            <input class="form-control"  type="text" required="" name="edit_movimiento" id="edit_movimiento" readonly="" value="<?php echo $row3['movimiento']; ?>">
                                                                                            <div class="valid-feedback">Se ve bien!</div>
                                                                                            <div class="invalid-feedback">Por favor, Seleccione el movimiento que desea hacer.</div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="button" class="btn btn-secondary  radius-30" data-bs-dismiss="modal">Cancelar</button>
                                                                                    <button type="submit" class="btn btn-warning  radius-30" >Guardar cambios</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>


                                                                <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#eliminar<?php echo $row3['id'] ?>">
                                                                    <i class="far fa-trash-alt opacity-5 me-2 text-danger"></i>        
                                                                </a>

                                                                <div class="modal fade" id="eliminar<?php echo $row3['id'] ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Eliminar movimiento</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/novedad-eliminar.php">
                                                                                <input class="form-control" type="text" required=""  name="delete_referencia" value="<?php echo $referencia; ?>" hidden >

                                                                                <input class="form-control" type="text" required="" name="delete_id"  value="<?php echo $row3['id'] ?>" hidden>
                                                                                <div class="modal-body row">
                                                                                    <div class="col-md-12">
                                                                                        <label class="form-label" for="validationCustom01">¿Estas seguro que deseas eliminar este registro?</label>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="button" class="btn btn-secondary  radius-30" data-bs-dismiss="modal">Cancelar</button>
                                                                                    <button type="submit" class="btn btn-danger  radius-30" >Eliminar</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>


                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>




                    <div class="card">
                        <div class="card-body">
                            <h5>Resumen novedad</h5>
                            <table class="table table-sm table-bordered table-striped text-sm table-hover" id="">
                                <thead>
                                    <tr class="">
                                        <th class="text-center p-2">Tallas</th>
                                        <th class="text-center p-2 bg-light-danger">Salida</th> 
                                        <th class="text-center p-2 bg-light-success">Entrada</th> 
                                        <th class="text-center p-2">Saldo</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $sql = "SELECT * FROM novedad WHERE referencia_producto='$referencia' AND tipo_novedad!='Devolucion' GROUP BY talla ORDER BY talla asc";
                                    $query = $conn->query($sql);
                                    if ($query->num_rows > 0) {
                                        while ($row = $query->fetch_assoc()) {

                                            $sql1 = "SELECT SUM(cantidad) AS cantidad_salida FROM novedad WHERE referencia_producto='$referencia' AND talla='" . $row['talla'] . "' AND movimiento='Salida' AND tipo_novedad!='Devolucion'";
                                            $query1 = $conn->query($sql1);
                                            $row1 = $query1->fetch_assoc();

                                            $sql2 = "SELECT SUM(cantidad) AS cantidad_entrada FROM novedad WHERE referencia_producto='$referencia' AND talla='" . $row['talla'] . "' AND movimiento='Entrada' AND tipo_novedad!='Devolucion'";
                                            $query2 = $conn->query($sql2);
                                            $row2 = $query2->fetch_assoc();
                                            ?>
                                            <tr>
                                                <td style="text-align: center;"><strong>T - <?php echo $row['talla']; ?></strong></td>
                                                <td class="text-center"><?php echo number_format($row1['cantidad_salida'], 0, ',', '.'); ?></td>
                                                <td class="text-center"><?php echo number_format($row2['cantidad_entrada'], 0, ',', '.'); ?></td>
                                                <td class="text-center"><?php echo number_format($row1['cantidad_salida'] + $row2['cantidad_entrada'], 0, ',', '.'); ?></td>
                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>

                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>



    </body>
</html>