<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">RPT - Mercancia por despachar</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center">
                            <h3><b> MERCANCIA POR DESPACHAR</b></h3>
                        </div>
                    </div>

                    <div class="card ">
                        <div class="card-body">


                            <style>
                                th, td { white-space: nowrap; }

                                div.dataTables_wrapper {
                                    width: 100%;
                                    margin: 0 auto;
                                }


                            </style>

                            <div class=" mt-3">
                                <table id="example" class="table table-striped table-bordered order-column" style="width:100%">
                                    <thead class="bg-gradient-info text-white">
                                        <tr class=" ">
                                            <th class="bg-gradient-info" >REFERENCIAS</th>
                                            <?php
                                            $sql = "SELECT talla FROM referencia_despacho GROUP BY talla ORDER BY talla asc";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {
                                                    ?>
                                                    <th class="text-center" ><?php echo $row['talla']; ?></th>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <th class="text-center">TOTAL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql1 = "SELECT referencia_producto FROM referencia_despacho GROUP BY referencia_producto ORDER BY referencia_producto asc";
                                        $query1 = $conn->query($sql1);
                                        if ($query1->num_rows > 0) {
                                            while ($row1 = $query1->fetch_assoc()) {
                                                ?>
                                                <tr class="" >
                                                    <td class="">
                                                        <b class="text-primary"><?php echo $row1['referencia_producto']; ?></b>
                                                    </td>


                                                    <?php
                                                    $total_talla = 0;
                                                    $sql2 = "SELECT talla FROM referencia_despacho GROUP BY talla ORDER BY talla asc";
                                                    $query2 = $conn->query($sql2);
                                                    if ($query2->num_rows > 0) {
                                                        while ($row2 = $query2->fetch_assoc()) {

                                                            $sql3 = "SELECT SUM(cantidad) as cantidad_despacho FROM referencia_despacho WHERE "
                                                                    . "referencia_producto='" . $row1['referencia_producto'] . "' AND talla='" . $row2['talla'] . "'";
                                                            $query3 = $conn->query($sql3);
                                                            $row3 = $query3->fetch_assoc();

                                                            $talla = number_format($row3['cantidad_despacho'],0);

                                                            if ($talla < 0) {
                                                                $bg_color_talla = 'bg-danger';
                                                                $text_color = 'text-white';
                                                            } elseif ($talla > 0) {
                                                                $bg_color_talla = 'bg-info';
                                                                $text_color = 'text-white';
                                                            } else {
                                                                $bg_color_talla = '';
                                                                $text_color = 'text-secondary';
                                                            }
                                                            ?>
                                                            <td class="text-center <?php echo $bg_color_talla; ?>" >
                                                                <b class="<?php echo $text_color; ?>"><?php echo $talla; ?></b>
                                                            </td>
                                                            <?php
                                                            $total_talla += $talla;
                                                        }
                                                    }
                                                    ?> 
                                                    <td class="text-center">
                                                        <?php
                                                        if ($total_talla < 0) {
                                                            $text_total_color = 'text-danger';
                                                        } elseif ($total_talla > 0) {
                                                            $text_total_color = 'text-info';
                                                        } else {
                                                            $text_total_color = '';
                                                        }
                                                        ?>

                                                        <h6><b class="<?php echo $text_total_color; ?>"><?php echo $total_talla; ?></b></h6>
                                                    </td>

                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>


                            <div class="text-end">
                                <span>Mercancia por despachar</span> <i class="fa-solid fa-square  text-info"></i>
                                <br>
                                <span>Mercancia que se despacho de mas</span>  <i class="fa-solid fa-square  text-danger"></i> 
                            </div>

                        </div>
                    </div>
                </div>

                <?php echo include '../general/footer.php'; ?>

            </div>
        </div>

        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            $(document).ready(function () {
                var table = $('#example').DataTable({
                    scrollY: "500px",
                    scrollX: true,
                    scrollCollapse: true,
                    paging: false,
                    ordering: false,
                    fixedColumns: {
                        left: 1,
                    },

                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    },

                });
                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>