<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $mes = $_GET['mes'];
    $year = $_GET['year'];
} else {
    $mes = date("m");
    $year = date("Y");
}

if ($mes == '01') {
    $mes_texto = 'Enero';
} elseif ($mes == '02') {
    $mes_texto = 'Febrero';
} elseif ($mes == '03') {
    $mes_texto = 'Marzo';
} elseif ($mes == '04') {
    $mes_texto = 'Abril';
} elseif ($mes == '05') {
    $mes_texto = 'Mayo';
} elseif ($mes == '06') {
    $mes_texto = 'Junio';
} elseif ($mes == '07') {
    $mes_texto = 'Julio';
} elseif ($mes == '08') {
    $mes_texto = 'Agosto';
} elseif ($mes == '09') {
    $mes_texto = 'Septiembre';
} elseif ($mes == '10') {
    $mes_texto = 'Octubre';
} elseif ($mes == '11') {
    $mes_texto = 'Noviembre';
} elseif ($mes == '12') {
    $mes_texto = 'Diciembre';
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Recaudo</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 col-sm-6 d-flex">
                                    <form class=" g-3 needs-validation p-2 bg-white"  method="GET" action="recaudo.php">
                                        <div class="row ">
                                            <div class="col-md-4">
                                                <label><strong>Año</strong></label>
                                                <select class="form-select" required="" name="year">
                                                    <option value="<?php echo $year; ?>"><?php echo $year; ?></option>
                                                    <option value="" disabled=""></option>
                                                    <option value="2023">2023</option>
                                                    <option value="2024">2024</option>

                                                </select>
                                            </div>
                                            <div class="col-md-5">
                                                <label><strong>Mes</strong></label>
                                                <select class="form-select" required="" name="mes">
                                                    <option value="<?php echo $mes ?>"><?php echo $mes_texto; ?></option>
                                                    <option value="" disabled=""></option>
                                                    <option value="01">Enero</option>
                                                    <option value="02">Febrero</option>
                                                    <option value="03">Marzo</option>
                                                    <option value="04">Abril</option>
                                                    <option value="05">Mayo</option>
                                                    <option value="06">Junio</option>
                                                    <option value="07">Julio</option>
                                                    <option value="08">Agosto</option>
                                                    <option value="09">Septiembre</option>
                                                    <option value="10">Octubre</option>
                                                    <option value="11">Noviembre</option>
                                                    <option value="12">Diciembre</option>
                                                </select>
                                            </div>
                                            <div class="col-md-3">
                                                <button type="submit" class="btn btn-info mt-3" name="filtro" >Consultar</button>
                                            </div>
                                        </div> 
                                    </form>
                                </div>
                            </div>

                            <hr>

                            <style>
                                #hover_enlace:hover{
                                    color: purple;
                                    border-radius: 10px; 
                                    box-shadow: 0px 0px 10px 0px purple;
                                }

                            </style>
                            <div class="table-responsive mt-2">
                                <table class="table align-middle mb-0 table-striped" style="width: 100%;">
                                    <thead>

                                        <tr class="">
                                            <th class="text-center bg-light-dark text-dark p-1" rowspan="2">FECHA</th>
                                            <th class="text-center bg-light-dark text-dark p-1" rowspan="2">CANTIDAD</th>
                                            <th class="text-center bg-light-warning text-warning p-1"  rowspan="2">COMPRA</th>
                                            <th class="text-center bg-light-info text-info p-1"  rowspan="2">VENTA</th>
                                            <th class="text-center bg-success text-white p-1" rowspan="2">TOTAL UTILIDAD</th>
                                            <th class="text-center bg-light-danger text-danger p-1" colspan="3" >GASTOS</th>
                                            <th class="text-center bg-danger text-white p-1" rowspan="2" >TOTAL GASTOS</th>
                                            <th class="text-center bg-info text-white p-1" rowspan="2" >TOTAL GANANCIA</th>
                                            <th class="text-center bg-info text-white p-1" rowspan="2" >ARRASTRE GANANCIA</th>
                                        </tr>
                                        <tr class="">
                                            <th class="text-center bg-light-danger text-danger p-1">Nomina</th>
                                            <th class="text-center bg-light-danger text-danger p-1">Bancarios</th>
                                            <th class="text-center bg-light-danger text-danger p-1">Varios</th>
                                        </tr>
                                    </thead>             
                                    <tbody>
                                        <?php
                                        $total_arrastre = 0;

                                        $sql = "SELECT fecha FROM venta WHERE YEAR(fecha)='$year' AND MONTH(fecha)='$mes'
                                            UNION 
                                            SELECT fecha FROM gasto WHERE YEAR(fecha)='$year' AND MONTH(fecha)='$mes' ORDER BY fecha asc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {

                                                $sql1 = "SELECT SUM(vd.cantidad) as cantidad_pares FROM venta v, venta_detalle vd WHERE v.id=vd.id_venta v.fecha='" . $row['fecha'] . "' AND v.estado='Entregado'";
                                                $query1 = $conn->query($sql1);
                                                $row1 = $query1->fetch_assoc();

                                                $sql2 = "SELECT SUM(total_venta - flete_empresa + abono_flete) as venta FROM venta WHERE fecha='" . $row['fecha'] . "' AND nombre_producto='Entregado'";
                                                $query2 = $conn->query($sql2);
                                                $row2 = $query2->fetch_assoc();

                                                $sql3 = "SELECT SUM() as venta FROM venta v, venta_detalle vd WHERE v.id=vd.id_venta v.fecha='" . $row['fecha'] . "' AND v.estado='Entregado'";
                                                $query3 = $conn->query($sql3);
                                                $row3 = $query3->fetch_assoc();

                                                $total_utilidad = $row1['util_acpm'] + $row2['util_gasolina'];

                                                $sql3 = "SELECT SUM(monto) as nomina FROM gasto WHERE fecha='" . $row['fecha'] . "' AND nombre_categoria='Nomina'";
                                                $query3 = $conn->query($sql3);
                                                $row3 = $query3->fetch_assoc();

                                                $sql5 = "SELECT SUM(monto) as vario FROM gasto WHERE fecha='" . $row['fecha'] . "' AND NOT nombre_categoria='Gastos Bancarios' AND NOT nombre_categoria='Nomina'";
                                                $query5 = $conn->query($sql5);
                                                $row5 = $query5->fetch_assoc();

                                                $total_gasto = $row3['nomina'] + $row4['bancario'] + $row5['vario'];

                                                $total_ganancia = $total_utilidad - $total_gasto;

                                                $total_arrastre += $total_ganancia;

                                                if ($total_arrastre < 0) {
                                                    $color_arrastre = "text-danger";
                                                } elseif ($total_arrastre > 0) {
                                                    $color_arrastre = "text-success";
                                                } else {
                                                    $color_arrastre = "text-dark";
                                                }
                                                ?>
                                                <tr>
                                                    <td class='text-center'><b><?php echo $row['fecha']; ?></b></td>
                                                    <td class='text-center'><?php echo number_format($row1['cantidad_pares']); ?></td>
                                                    <td class='text-end'><b class="float-start">$</b> <?php echo number_format($row1['util_acpm']); ?></td>
                                                    <td class='text-center'><?php echo number_format($row2['gls_gasolina'], 3); ?></td>
                                                    <td class='text-end'><b class="float-start">$</b> <?php echo number_format($row2['util_gasolina'], 0); ?></td>
                                                    <td class='text-end bg-light-success'><b class="float-start">$</b> <b><?php echo number_format($total_utilidad, 0); ?></b></td>
                                                    <td class='text-end bg-light-danger'><b class="float-start">$</b> <?php echo number_format($row3['nomina'], 0); ?></td>
                                                    <td class='text-end bg-light-danger'><b class="float-start">$</b> <?php echo number_format($row4['bancario'], 0); ?></td>
                                                    <td class='text-end bg-light-danger'><b class="float-start">$</b> <?php echo number_format($row5['vario'], 0); ?></td>
                                                    <td class='text-end bg-light-danger'><b class="float-start">$</b> <b><?php echo number_format($total_gasto, 0); ?></b></td>
                                                    <td class='text-end bg-light-info'><b class="float-start">$</b> <b><?php echo number_format($total_ganancia, 0); ?></b></td>
                                                    <td class='text-end bg-light-info <?php echo $color_arrastre; ?>'><b class="float-start">$</b> <b><?php echo number_format($total_arrastre, 0); ?></b></td>
                                                </tr>
        <?php
    }
}
?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>    

                </div>
<?php echo include '../general/footer.php'; ?>
            </div>
        </div>
        <!--end wrapper-->
<?php echo include '../general/libreria-js.php'; ?>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>