<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario       = post('nombre_usuario');

$referencia_segmento  = post('referencia_segmento');
$codigo               = post('codigo');
$referencia           = post('referencia');

$color                = post('color');
$color2               = post('color2');

$categoria            = post('categoria');
$clase                = post('clase');
$peso                 = post('peso');
$descripcion          = post('descripcion', 'No aplica');
$precio_venta         = post('precio_venta');

$foto1 = 'NO APLICA';
$foto2 = 'NO APLICA';
$foto3 = 'NO APLICA';
$foto4 = 'NO APLICA';
$habilitado = 'No';
$bodega = 'FABRICA';

$alm_costo_unidad = 0;
$alm_precio_unidad = 0;

// bicolor
$bicolor = ($color !== '' && $color2 !== '' && $color === $color2) ? 'si' : 'no';

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_usuario === '')      $errores[] = 'Falta nombre_usuario';
if ($codigo === '')              $errores[] = 'Falta codigo';
if ($referencia_segmento === '') $errores[] = 'Falta referencia_segmento';
if ($referencia === '')          $errores[] = 'Falta referencia';
if ($color === '')               $errores[] = 'Falta color';
if ($color2 === '')              $errores[] = 'Falta color2';
if ($categoria === '')           $errores[] = 'Falta categoria';
if ($clase === '')               $errores[] = 'Falta clase';

if ($peso === '' || !is_numeric($peso) || (float)$peso < 0) {
    $errores[] = 'Peso inválido';
}

if ($precio_venta === '' || !is_numeric($precio_venta) || (float)$precio_venta < 0) {
    $errores[] = 'Precio de venta inválido';
}

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

/* ---------------- Insert seguro ---------------- */
$stmt = $conn->prepare("
    INSERT INTO producto
    (codigo, nombre_usuario, referencia_segmento, referencia, color, color2, bicolor,
     categoria, clase, peso, foto1, foto2, foto3, foto4, precio_venta, habilitado,
     descripcion, alm_costo_unidad, alm_precio_unidad, bodega)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
");

if (!$stmt) {
    http_response_code(500);
    exit("Error prepare: " . $conn->error);
}

$peso_num = (float)$peso;
$precio_num = (float)$precio_venta;

// types: s s s s s s s  s s d  s s s s d s  s d d s
$stmt->bind_param(
    "sssssss" . "ssd" . "ssss" . "ds" . "sdd" . "s",
    $codigo,
    $nombre_usuario,
    $referencia_segmento,
    $referencia,
    $color,
    $color2,
    $bicolor,
    $categoria,
    $clase,
    $peso_num,
    $foto1,
    $foto2,
    $foto3,
    $foto4,
    $precio_num,
    $habilitado,
    $descripcion,
    $alm_costo_unidad,
    $alm_precio_unidad,
    $bodega
);

if (!$stmt->execute()) {
    http_response_code(500);
    exit("Error al guardar: " . $stmt->error);
}

$stmt->close();

// PRG redirect (evita doble insert por refresh)
header("Location: ../kardex.php?referencia=" . urlencode($referencia));
exit;
