<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="produccion-panel.php">
                                    Panel produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="produccion-orden.php">
                                    Ordenes produccion
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Paso 1</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body">
                            <h4 class="text-center"><b>GENERAR ORDEN DE PRODUCCION</b></h4>
                        </div>
                    </div>

                    <style>
                        #hover_enlace:hover{
                            box-shadow: 0px 0px 20px 0px #3C3D6B;
                        }

                    </style>                    

                    <div class="row mb-2">
                        <div class="col-sm-4">
                            <a href="#">
                                <div class="alert alert-success fade show mb-0 ">
                                    <strong class="alert-heading">PASO 1:</strong> Selecione maquina a trabajar.
                                </div>
                            </a>
                        </div>
                        <div class="col-sm-4">
                            <a href="#">
                                <div class="alert alert-warning fade show mb-0 ">
                                    <strong class="alert-heading">PASO 2:</strong> Seleccione color.
                                </div>
                            </a>
                        </div>
                        <div class="col-sm-4">
                            <a href="#">
                                <div class="alert alert-warning fade show mb-0 ">
                                    <strong class="alert-heading">PASO 3:</strong> Imprimir ventas seleccionadas.
                                </div>
                            </a>
                        </div>
                    </div>




                    <div class="card radius-10 w-100">
                        <div class="card-body">

                            <hr>


                            <div class="row">

                                <?php
                                $sql = "SELECT * FROM maquina ";
                                $query = $conn->query($sql);
                                if ($query->num_rows > 0) {
                                    while ($row = $query->fetch_assoc()) {
                                        ?>
                                        <div class="col-3 mt-2"  >
                                            <div class="card radius-10  mb-0 " style="box-shadow: 0px 1px 5px 2px #EAE6E6; border-radius: 15px;">
                                                <a href="produccion-orden-p2.php?nombre_maquina=<?php echo $row['nombre']; ?>" id="hover_enlace" style="border-radius: 15px;">
                                                    <div class="card-body ">
                                                        <div class="d-flex align-items-center gap-3">

                                                            <h5 class="mb-0 text-dark"><?php echo $row['nombre']; ?></h5>

                                                            <div class="ms-auto">

                                                                <i class="fa-solid fa-circle fa-2x"></i>

                                                            </div>
                                                        </div>
                                                        <hr class="">

                                                        <?php
                                                        $sql1 = "SELECT * FROM maquina_material WHERE nombre_maquina='" . $row['nombre'] . "' ";
                                                        $query1 = $conn->query($sql1);
                                                        if ($query1->num_rows > 0) {
                                                            while ($row1 = $query1->fetch_assoc()) {
                                                                echo $row1['nombre_categoria'];
                                                            }
                                                        }
                                                        ?>


                                                    </div>
                                                </a>
                                            </div>
                                        </div>

                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            $('.single-select-producto').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });

            $('#talla').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),

            });


            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>