<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_pedido           = post('id_pedido');
$referencia_producto = post('referencia_producto');
$talla               = post('talla');
$cantidad            = post('cantidad');
$estado              = post('estado');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id_pedido === '' || !ctype_digit($id_pedido) || (int)$id_pedido <= 0) $errores[] = 'id_pedido inválido';
if ($referencia_producto === '') $errores[] = 'Falta referencia_producto';
if ($talla === '') $errores[] = 'Falta talla';
if ($estado === '') $errores[] = 'Falta estado';

if ($cantidad === '' || !is_numeric($cantidad) || (int)$cantidad <= 0) $errores[] = 'Cantidad inválida';
$cantidad_int = (int)$cantidad;

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_pedido;

try {
    $conn->begin_transaction();

    // 1) Verificar que el pedido exista y obtener nombre_tercero
    $stmtP = $conn->prepare("SELECT nombre_tercero FROM pedido WHERE id = ? LIMIT 1");
    if (!$stmtP) throw new Exception("Prepare pedido: " . $conn->error);

    $stmtP->bind_param("i", $id_int);
    $stmtP->execute();
    $resP = $stmtP->get_result();
    $rowt = $resP->fetch_assoc();
    $stmtP->close();

    if (!$rowt) {
        throw new Exception("El pedido no existe");
    }

    // 2) Insert detalle (prepared)
    $stmtI = $conn->prepare("
        INSERT INTO pedido_detalle
        (id_pedido, referencia_producto, talla, cantidad, estado)
        VALUES (?,?,?,?,?)
    ");
    if (!$stmtI) throw new Exception("Prepare insert detalle: " . $conn->error);

    // i s s i s
    $stmtI->bind_param("issis", $id_int, $referencia_producto, $talla, $cantidad_int, $estado);

    if (!$stmtI->execute()) throw new Exception("Execute insert detalle: " . $stmtI->error);
    $stmtI->close();

    // 3) Tus clases (inventario y cierre)
    $class_referencia = $referencia_producto;
    $class_talla = $talla;
    require '../../../clases/class-referencia.php';

    $class_nombre_tercero_cierre = $rowt['nombre_tercero'];
    $class_referencia_cierre = $referencia_producto;
    $class_talla_cierre = $talla;
    require '../../../clases/class-cierre.php';

    $conn->commit();

    // PRG redirect (sin &&)
    header("Location: ../pedido-detalle.php?id_pedido=" . $id_int
        . "&referencia_producto=" . urlencode($referencia_producto)
    );
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
