<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$nombre_usuario = post('nombre_usuario');
$fecha          = post('fecha');
$numero_pedido  = post('numero_pedido'); // (llega pero NO lo usabas; lo dejas por compatibilidad)
$nombre_tercero = post('nombre_tercero');
$observacion    = post('observacion', 'No aplica');

$estado          = 'Proceso';
$panel_impresion = 'No';
$documento_guia  = 'No aplica';

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($nombre_usuario === '')  $errores[] = 'Falta nombre_usuario';
if ($nombre_tercero === '')  $errores[] = 'Falta nombre_tercero';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

try {
    $conn->begin_transaction();

    /* 1) Consecutivo seguro
       OJO: tu numero_pedido es texto, pero contiene números.
       Calculamos MAX como UNSIGNED para evitar "10" < "9".
       Con FOR UPDATE reduces el riesgo de que dos usuarios saquen el mismo consecutivo.
    */
    $res = $conn->query("
        SELECT COALESCE(MAX(CAST(numero_pedido AS UNSIGNED)),0) AS mayor
        FROM pedido
        FOR UPDATE
    ");
    $row = $res->fetch_assoc();
    $codigo = ((int)$row['mayor']) + 1;

    /* 2) Insert con prepared */
    $stmt = $conn->prepare("
        INSERT INTO pedido
        (nombre_usuario, alm_nombre_usuario, fecha, numero_pedido, nombre_tercero, observacion, estado, panel_impresion, documento_guia)
        VALUES (?, NULL, ?, ?, ?, ?, ?, ?, ?)
    ");
    if (!$stmt) throw new Exception("Prepare pedido: " . $conn->error);

    // types: s s i s s s s s  (numero_pedido lo meto como string por si tu campo es VARCHAR)
    $codigo_str = (string)$codigo;

    $stmt->bind_param(
        "ssssssss",
        $nombre_usuario,
        $fecha,
        $codigo_str,
        $nombre_tercero,
        $observacion,
        $estado,
        $panel_impresion,
        $documento_guia
    );

    if (!$stmt->execute()) throw new Exception("Execute pedido: " . $stmt->error);

    $id_pedido = $conn->insert_id;
    $stmt->close();

    $conn->commit();

    // PRG redirect (evita duplicado por refresh)
    header("Location: ../pedido-detalle.php?id_pedido=" . (int)$id_pedido);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
