<?php
/**
 * pedido-estado-editar.php
 *
 * Cambia el estado de un pedido **solo** mediante POST,
 * protegido con token CSRF y sentencias preparadas.
 */
session_start();
include '../../../script/conexion.php';

/* ──────────────────────────────
 | 1.  Validaciones básicas
 ────────────────────────────── */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);            // 405 = Method Not Allowed
    exit('Método no permitido');
}

if (!hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf'] ?? '')) {
    http_response_code(403);            // 403 = Forbidden
    exit('Token CSRF inválido');
}

$id_pedido = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
$estado    = $_POST['estado']          ?? '';

$permitidos = ['Proceso', 'Confirmado', 'Recibido', 'Cancelado'];
if ($id_pedido <= 0 || !in_array($estado, $permitidos, true)) {
    http_response_code(400);            // 400 = Bad Request
    exit('Parámetros incorrectos');
}

/* ──────────────────────────────
 | 2.  Operaciones en una transacción
 ────────────────────────────── */
$conn->begin_transaction();

try {
    /* 2-A)   Actualiza la cabecera del pedido */
    $stmt = $conn->prepare(
        "UPDATE pedido SET estado = ? WHERE id = ?"
    );
    $stmt->bind_param('si', $estado, $id_pedido);
    $stmt->execute();

    /* 2-B)   Actualiza cada línea del pedido */
    $stmt2 = $conn->prepare(
        "UPDATE pedido_detalle SET estado = ? WHERE id_pedido = ?"
    );
    $stmt2->bind_param('si', $estado, $id_pedido);
    $stmt2->execute();

    /* 2-C)   Carga datos que necesitarán las clases auxiliares */
    $stmt3 = $conn->prepare(
        "SELECT nombre_tercero FROM pedido WHERE id = ?"
    );
    $stmt3->bind_param('i', $id_pedido);
    $stmt3->execute();
    $rowPedido = $stmt3->get_result()->fetch_assoc();

    $stmt4 = $conn->prepare(
        "SELECT referencia_producto, talla
           FROM pedido_detalle
          WHERE id_pedido = ?"
    );
    $stmt4->bind_param('i', $id_pedido);
    $stmt4->execute();
    $rsDetalle = $stmt4->get_result();

    while ($rowDet = $rsDetalle->fetch_assoc()) {

        /* Parámetros que tus clases esperan */
        $class_referencia           = $rowDet['referencia_producto'];
        $class_talla                = $rowDet['talla'];

        include '../../../clases/class-referencia.php';

        $class_nombre_tercero_cierre = $rowPedido['nombre_tercero'];
        $class_referencia_cierre     = $rowDet['referencia_producto'];
        $class_talla_cierre          = $rowDet['talla'];

        include '../../../clases/class-cierre.php';
    }

    $conn->commit();

    /* 2-D)   Redirección tipo PRG (Post/Redirect/Get) */
    header("Location: ../pedido-detalle.php?id_pedido=$id_pedido");
    exit;

} catch (Throwable $e) {
    $conn->rollback();
    http_response_code(500);            // 500 = Internal Server Error
    echo "Error en la transacción: " . $e->getMessage();
}
