<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Nomina</li>
                        </ol>
                    </nav>





                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-0 text-uppercase">Lista de asesores</h6>
                            <hr/>
                            <div class="table-responsive mt-2">
                                <table class="table align-middle mb-0" id="example2" style="width: 100%;">
                                    <thead>
                                        <tr class="text-center">
                                            <th >Nombre</th>
                                            <th class="">Rol</th>
                                            <th class="">Cuenta</th>
                                            <th class="">Tipo de cuenta</th>
                                            <th class="text-center">Monto</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM usuario WHERE rol='asesor'";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>
                                                <tr class="align-middle">
                                                    <td>
                                                        <strong><?php echo $row['nombre']; ?></strong>
                                                    </td>
                                                    <td class="">
                                                        <strong><?php echo $row['rol']; ?></strong><br>
                                                        <span class="text-muted">***********</span>
                                                    </td>
                                                    <td class="text-center">
                                                        Por definir
                                                    </td>
                                                    <td class="text-center" style="min-width: 125px;">
                                                        Por definir
                                                    </td>
                                                    <td class="text-center">
                                                        Por definir
                                                    </td>
                                                    <td class="text-center">
                                                        <a  href="nomina-asesor.php?nombre_usuario=<?php echo $row['nombre']; ?>">
                                                            <i class="fas fa-file-invoice-dollar opacity-5 me-4 fa-2x text-primary"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>



        <div class="modal fade" id="editar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar de usuarios</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/usuario-editar.php">
                        <input class="form-control" type="text" required="" name="edit_id" id="edit_id" hidden>
                        <div class="modal-body ">
                            <h6 class="mt-3">Información del usuario:</h6> 
                            <div class="row ">
                                <div class="col-md-4">
                                    <label class="form-label" for="validationCustom01">Cedula</label>
                                    <input class="form-control" type="text" required="" name="edit_cedula" id="edit_cedula">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca un numero de cedula.</div>
                                </div>
                                <div class="col-md-8">
                                    <label class="form-label" for="validationCustom02">Primer nombre y apellido</label>
                                    <input class="form-control" type="text" required="" name="edit_nombre" id="edit_nombre">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca un nombre de pila.</div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-8">
                                    <label class="form-label" for="validationCustomUsername">Correo</label>
                                    <div class="input-group has-validation"><span class="input-group-text" id="inputGroupPrepend">@</span>
                                        <input class="form-control" type="text" aria-describedby="inputGroupPrepend" required="" name="edit_correo" id="edit_correo">
                                        <div class="valid-feedback">Se ve bien!</div>
                                        <div class="invalid-feedback">Por favor, introduzca un correo electronico.</div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label" for="validationCustom02">Telefono</label>
                                    <input class="form-control" type="text" required="" name="edit_telefono" id="edit_telefono">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca un numero de telefono.</div>
                                </div>
                            </div>

                            <h6 class="mt-4">Datos de acceso:</h6>


                            <div class="row mt-1">
                                <div class="col-md-3">
                                    <label class="form-label" for="validationCustom02">Usuario</label>
                                    <input class="form-control" type="text"  required="" name="edit_usuario" id="edit_usuario">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca su nombre de usuario.</div>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label" for="validationCustom03">Clave</label>
                                    <input class="form-control" type="text" required="" name="edit_clave" id="edit_clave">
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, introduzca un clave.</div>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" for="validationCustom04">Rol</label>
                                    <select class="form-select"  required="" name="edit_rol" id="edit_rol">
                                        <option selected="" disabled="" value="">Seleccione</option>
                                        <option value="Administrador">Administrador</option>
                                        <option value="Asesor">Asesor</option>
                                        <option value="Bodega">Bodega</option>
                                        <option value="Seguimiento">Seguimiento</option>
                                    </select>
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-md-3">
                                    <label class="form-label" for="validationCustom04">Estado</label>
                                    <select class="form-select" required="" name="edit_estado" id="edit_estado">
                                        <option selected="" disabled="" value="">Seleccione</option>
                                        <option value="Activo">Activo</option>
                                        <option value="Inactivo">Inactivo</option>
                                    </select>
                                    <div class="valid-feedback">Se ve bien!</div>
                                    <div class="invalid-feedback">Por favor, seleccione el estado del usuario.</div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary px-5 radius-30" data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-warning px-5 radius-30" >Guardar cambios</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            // PASO DE PARAMETROS EDITAR
            $('#editar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var cedula = button.data('cedula')
                var nombre = button.data('nombre')
                var correo = button.data('correo')
                var telefono = button.data('telefono')
                var usuario = button.data('usuario')
                var clave = button.data('clave')
                var rol = button.data('rol')
                var estado = button.data('estado')

                $('#edit_id').val(id)
                $('#edit_cedula').val(cedula)
                $('#edit_nombre').val(nombre)
                $('#edit_correo').val(correo)
                $('#edit_telefono').val(telefono)
                $('#edit_usuario').val(usuario)
                $('#edit_clave').val(clave)
                $('#edit_rol').val(rol)
                $('#edit_estado').val(estado)
            });

        </script>


        <div class="modal fade" id="eliminar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title card-heading" id="exampleModalLabel">Confirmacion | Eliminar usuario</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/usuario-eliminar.php">
                        <input class="form-control" type="text" required="" name="delete_id" id="delete_id" hidden>
                        <div class="modal-body row">
                            <div class="col-md-12">
                                <label class="form-label" for="validationCustom01">¿Estas seguro que deseas eliminar la siguiente usuario?</label>
                                <input class="form-control text-sm" type="text" required="" name="delete_nombre" id="delete_nombre" readonly="">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-danger" >Eliminar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            // PASO DE PARAMETROS EDITAR
            $('#eliminar').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal

                var id = button.data('id')
                var nombre = button.data('nombre')

                $('#delete_id').val(id)
                $('#delete_nombre').val(nombre)
            });

        </script>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>