<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = $_GET['nombre_tercero'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none p-3">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Reporte de produccion</li>
                    </ol>
                </nav>





                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">

                                    <form method="GET" action="rpt-produccion-operario.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2 ">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>


                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Operario</label>
                                                    <select class="form-control form-control-sm" name="nombre_tercero" required>

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($nombre_tercero != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $nombre_tercero; ?>"><?php echo $nombre_tercero; ?></option>
                                                                <option value="" disabled=""></option>
                                                                <option value="todo">Todos</option>
                                                                <?php
                                                            } else {
                                                                ?>
                                                                <option value="todo">Todos</option>
                                                                <option value="" disabled=""></option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="todo">Todos</option>
                                                            <option value="" disabled=""></option>
                                                            <?php
                                                        }
                                                        ?>

                                                        <?php
                                                        $sql6m = "SELECT * FROM tercero WHERE tipo='Empleado'";
                                                        $query6m = $conn->query($sql6m);
                                                        if ($query6m->num_rows > 0) {
                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                ?>

                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>

                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>




                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="card">
                    <div class="card-body text-center">
                        <h5 class="text-center"><b>OPERARIOS <br>REPORTE DE PRODUCCION</b></h5>         
                        <h6>
                            <b><?php echo date('d-m-Y', strtotime($fecha_desde)); ?></b> 
                            <b class="text-secondary me-3 ms-3"> al</b> 
                            <b><?php echo date('d-m-Y', strtotime($fecha_hasta)); ?></b>
                        </h6>

                    </div>
                </div>


                <div class="d-print-none">
                    <div class="float-end">
                        <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                            <i class="fas fa-print"> Imprimir</i>
                        </a>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <br><!-- comment -->


                <?php
                if (isset($_GET['filtro'])) {

                    $fecha_desde = $_GET['fecha_desde'];
                    $fecha_hasta = $_GET['fecha_hasta'];
                    $nombre_tercero = $_GET['nombre_tercero'];

                    if ($nombre_tercero == 'todo') {
                        $sql_nombre_tercero = "";
                    } else {
                        $sql_nombre_tercero = " AND nombre_tercero='" . $nombre_tercero . "'";
                    }

                    $sql_fecha = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";

                    $sql = $sql_fecha . $sql_nombre_tercero;

                    $sql = "SELECT * FROM produccion WHERE $sql GROUP BY nombre_tercero";
                    $query = $conn->query($sql);
                    if ($query->num_rows > 0) {
                        while ($row = $query->fetch_assoc()) {
                            ?>

                            <div class="card">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <h6 class="mb-0 text-uppercase">
                                                <b><?php echo $row['nombre_tercero']; ?></b> 
                                            </h6>
                                        </div>  
                                        <div class="col-sm-6 text-end">

                                        </div>

                                    </div>
                                    <hr/>

                                    <div class="table-responsive mt-3">

                                        <table class="table table-hover text-sm table-sm table-striped table-bordered" >
                                            <thead>

                                                <tr class="bg-light-primary text-primary">
                                                    <th class=" p-1 " style="width: 5%;" >Foto</th>
                                                    <th class=" p-1 " style="width: 12%;" >Referencia</th>
                                                    <th class="text-center p-1 "  style="width: 6%;" >Categorias</th>
                                                    <th class="text-center p-1 "  style="width: 5%;" >Color</th>

                                                    <?php
                                                    $item = 0;
                                                    $sqlt1 = "SELECT * FROM produccion WHERE $sql_fecha AND nombre_tercero='" . $row['nombre_tercero'] . "'  GROUP BY talla ORDER BY talla asc";
                                                    $queryt1 = $conn->query($sqlt1);
                                                    if ($queryt1->num_rows > 0) {
                                                        while ($rowt1 = $queryt1->fetch_assoc()) {
                                                            ?>
                                                            <th class="text-center p-1"><?php echo $rowt1['talla']; ?></th>
                                                            <?php
                                                            $item++;
                                                        }
                                                    }
                                                    ?>
                                                    <th class="text-center p-1" style="width: 5%;">T. Prda</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $total_cantidad = 0;
                                                $total_venta = 0;
                                                $sql1 = "SELECT * FROM produccion WHERE $sql_fecha AND nombre_tercero='" . $row['nombre_tercero'] . "' GROUP BY referencia_producto";
                                                $query1 = $conn->query($sql1);
                                                if ($query1->num_rows > 0) {
                                                    while ($row1 = $query1->fetch_assoc()) {

                                                        $sql2 = "SELECT * FROM producto WHERE referencia='" . $row1['referencia_producto'] . "'";
                                                        $query2 = $conn->query($sql2);
                                                        $row2 = $query2->fetch_assoc();

                                                        ////CANTIDAD POR REFERENCIA
                                                        $sqlCANT = "SELECT SUM(cantidad) as cantidad_referencia FROM produccion WHERE $sql_fecha AND referencia_producto='" . $row1['referencia_producto'] . "' AND nombre_tercero='" . $row['nombre_tercero'] . "'";
                                                        $queryCANT = $conn->query($sqlCANT);
                                                        $rowCANT = $queryCANT->fetch_assoc();
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td class="text-center"> 
                                                                <?php
                                                                if ($row2['foto1'] == 'NO APLICA') {
                                                                    ?>
                                                                    <img class="img-thumbnail" src="../../img/logo.png" width="40" alt="alt"/>
                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <img class="" src="../../img-producto/<?php echo $row2['foto1']; ?>" width="40" height="40" alt="alt"/>
                                                                    <?php
                                                                }
                                                                ?>
                                                            </td>
                                                            <td> 
                                                                <strong class="text-dark"><?php echo $row2['referencia']; ?></strong>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="text-muted text-sm"><?php echo $row2['categoria']; ?></span><br>
                                                            </td>
                                                            <td class="text-center">
                                                                <span class="text-muted text-sm"><?php echo $row2['color']; ?></span><br>
                                                            </td>

                                                            <?php
                                                            $queryt2 = $conn->query($sqlt1);
                                                            if ($queryt2->num_rows > 0) {
                                                                while ($rowt2 = $queryt2->fetch_assoc()) {

                                                                    $sqlt4 = "SELECT SUM(cantidad) as suma_talla FROM produccion WHERE $sql_fecha AND referencia_producto='" . $row1['referencia_producto'] . "' AND talla='" . $rowt2['talla'] . "' AND nombre_tercero='" . $row['nombre_tercero'] . "'";
                                                                    $queryt4 = $conn->query($sqlt4);
                                                                    $rowt4 = $queryt4->fetch_assoc();

                                                                    $suma_talla = $rowt4['suma_talla'];
                                                                    ?>
                                                                    <td class="ancho text-center">
                                                                        <?php
                                                                        if ($suma_talla > 0) {
                                                                            ?>
                                                                            <h6>
                                                                                <b class=""><?php echo number_format($suma_talla,); ?></b>
                                                                            </h6>
                                                                            <?php
                                                                        } else {
                                                                            echo number_format($suma_talla,);
                                                                        }
                                                                        ?>
                                                                    </td>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                            <td class="text-center">
                                                                <h5>
                                                                    <b><?php echo $rowCANT['cantidad_referencia']; ?></b>
                                                                </h5>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        $total_cantidad += $rowCANT['cantidad_referencia'];
                                                    }
                                                }
                                                ?>


                                            </tbody>
                                            <tfoot>
                                                <tr class="bg-light-dark">
                                                    <th colspan="<?php echo $item + 4; ?>" class="text-end"> 
                                                        <h5>
                                                            <b>TOTAL</b>
                                                        </h5>
                                                    </th>                                                                          
                                                    <th colspan="3" class="text-center">
                                                        <h5>
                                                            <b><?php echo $total_cantidad; ?></b>
                                                        </h5>
                                                    </th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>


                                </div>
                            </div>



                            <?php
                        }
                    }
                } else {
                    ?>
                    <div class="row">
                        <div class="col-sm-12">
                            <h5> No hay resultados para mostrar</h5>
                        </div>
                    </div>

                    <?php
                }
                ?>


            </div>


            <!-- end page content-->
        </div>
        <!--end page content wrapper-->


        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>