<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_despacho         = post('edit_id_despacho_pq');
$referencia_producto = post('edit_referencia_producto_pq');
$precio_unidad_raw   = post('edit_precio_unidad_pq');
$cantidad_raw        = post('edit_cantidad_pq');

// cantidad viene con separadores, lo normalizamos
$edit_cantidad = (int)preg_replace('/[^0-9]+/', '', (string)$cantidad_raw);

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id_despacho === '' || !ctype_digit($id_despacho) || (int)$id_despacho <= 0) $errores[] = 'id_despacho inválido';
if ($referencia_producto === '') $errores[] = 'Falta referencia_producto';

if ($precio_unidad_raw === '' || !is_numeric($precio_unidad_raw) || (float)$precio_unidad_raw < 0) {
    $errores[] = 'precio_unidad inválido';
}
$precio_unidad = (float)$precio_unidad_raw;

if ($edit_cantidad <= 0) $errores[] = 'cantidad inválida (debe ser > 0)';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_despacho;

try {
    $conn->begin_transaction();

    // 1) Buscar si existe fila exacta (id_despacho + referencia + precio)
    $stmtSel = $conn->prepare("
        SELECT id
        FROM despacho_paquete
        WHERE id_despacho = ? AND referencia_producto = ? AND precio_unidad = ?
        LIMIT 1
    ");
    if (!$stmtSel) throw new Exception("Prepare select: " . $conn->error);

    $stmtSel->bind_param("isd", $id_int, $referencia_producto, $precio_unidad);
    $stmtSel->execute();
    $resSel = $stmtSel->get_result();
    $existe = (bool)$resSel->fetch_assoc();
    $stmtSel->close();

    if ($existe) {
        // UPDATE
        $stmtUp = $conn->prepare("
            UPDATE despacho_paquete
            SET cantidad = ?
            WHERE id_despacho = ? AND referencia_producto = ? AND precio_unidad = ?
        ");
        if (!$stmtUp) throw new Exception("Prepare update: " . $conn->error);

        $stmtUp->bind_param("iisd", $edit_cantidad, $id_int, $referencia_producto, $precio_unidad);
        if (!$stmtUp->execute()) throw new Exception("Execute update: " . $stmtUp->error);
        $stmtUp->close();

    } else {
        // INSERT
        $stmtIns = $conn->prepare("
            INSERT INTO despacho_paquete (id_despacho, referencia_producto, precio_unidad, cantidad)
            VALUES (?,?,?,?)
        ");
        if (!$stmtIns) throw new Exception("Prepare insert: " . $conn->error);

        $stmtIns->bind_param("isdi", $id_int, $referencia_producto, $precio_unidad, $edit_cantidad);
        if (!$stmtIns->execute()) throw new Exception("Execute insert: " . $stmtIns->error);
        $stmtIns->close();
    }

    $conn->commit();

    // PRG redirect
    header("Location: ../despacho-detalle.php?id_despacho=" . $id_int);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
