<?php
session_start();
require '../../../script/conexion.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

function post($k, $default = '') {
    return trim($_POST[$k] ?? $default);
}

$id_despacho    = post('id_despacho');
$nombre_usuario = post('nombre_usuario'); // lo recibes, pero no lo usas en UPDATE (lo dejo por compatibilidad)

$fecha          = post('fecha');
$nombre_tercero = post('nombre_tercero');
$numero_despacho= post('numero_despacho');

$cedula     = post('cedula');
$nombre     = post('nombre');
$direccion  = post('direccion');
$destino    = post('destino');
$telefono   = post('telefono');
$correo     = post('correo');
$observacion= post('observacion', 'No aplica');

/* ---------------- Validaciones ---------------- */
$errores = [];

if ($id_despacho === '' || !ctype_digit($id_despacho) || (int)$id_despacho <= 0) $errores[] = 'id_despacho inválido';
if ($nombre_tercero === '') $errores[] = 'Falta nombre_tercero';
if ($numero_despacho === '') $errores[] = 'Falta numero_despacho';

$dt = DateTime::createFromFormat('Y-m-d', $fecha);
if (!$dt || $dt->format('Y-m-d') !== $fecha) $errores[] = 'Fecha inválida';

// estos los puedes aflojar si en tu sistema son opcionales
if ($cedula === '')    $errores[] = 'Falta cedula';
if ($nombre === '')    $errores[] = 'Falta nombre';
if ($direccion === '') $errores[] = 'Falta direccion';
if ($destino === '')   $errores[] = 'Falta destino';

if ($errores) {
    http_response_code(400);
    exit('Error: ' . implode(', ', $errores));
}

$id_int = (int)$id_despacho;

try {
    $conn->begin_transaction();

    /* 1) Traer despacho anterior (para nombre_tercero anterior) */
    $stmtOld = $conn->prepare("SELECT nombre_tercero FROM despacho WHERE id = ? LIMIT 1");
    if (!$stmtOld) throw new Exception("Prepare despacho old: " . $conn->error);

    $stmtOld->bind_param("i", $id_int);
    $stmtOld->execute();
    $resOld = $stmtOld->get_result();
    $rowt = $resOld->fetch_assoc();
    $stmtOld->close();

    if (!$rowt) {
        throw new Exception("El despacho no existe");
    }

    $tercero_anterior = $rowt['nombre_tercero'];

    /* 2) Update encabezado (prepared) */
    $stmtUp = $conn->prepare("
        UPDATE despacho
        SET fecha = ?,
            nombre_tercero = ?,
            numero_despacho = ?,
            cedula = ?,
            nombre = ?,
            direccion = ?,
            destino = ?,
            telefono = ?,
            correo = ?,
            observacion = ?
        WHERE id = ?
        LIMIT 1
    ");
    if (!$stmtUp) throw new Exception("Prepare update: " . $conn->error);

    $stmtUp->bind_param(
        "ssssssssssi",
        $fecha,
        $nombre_tercero,
        $numero_despacho,
        $cedula,
        $nombre,
        $direccion,
        $destino,
        $telefono,
        $correo,
        $observacion,
        $id_int
    );

    if (!$stmtUp->execute()) throw new Exception("Execute update: " . $stmtUp->error);
    $stmtUp->close();

    /* 3) Traer detalle y recalcular cierres */
    $stmtDet = $conn->prepare("SELECT referencia_producto, talla FROM despacho_detalle WHERE id_despacho = ?");
    if (!$stmtDet) throw new Exception("Prepare detalle: " . $conn->error);

    $stmtDet->bind_param("i", $id_int);
    $stmtDet->execute();
    $resDet = $stmtDet->get_result();

    while ($row3 = $resDet->fetch_assoc()) {

        // A) aplicar cierre al nuevo tercero
        $class_nombre_tercero_cierre = $nombre_tercero;
        $class_referencia_cierre = $row3['referencia_producto'];
        $class_talla_cierre = $row3['talla'];
        require '../../../clases/class-cierre.php';

        // B) aplicar cierre al tercero anterior
        $class_nombre_tercero_cierre = $tercero_anterior;
        $class_referencia_cierre = $row3['referencia_producto'];
        $class_talla_cierre = $row3['talla'];
        require '../../../clases/class-cierre.php';
    }

    $stmtDet->close();

    $conn->commit();

    // PRG redirect
    header("Location: ../despacho-detalle.php?id_despacho=" . $id_int);
    exit;

} catch (Exception $e) {
    $conn->rollback();
    http_response_code(500);
    exit("Error: " . $e->getMessage());
}
