<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

/*  Colores de estado  */
$badgeClass = [
    'Proceso'  => 'bg-info text-white',
    'Enviado'  => 'bg-warning text-dark',
    'Recibido' => 'bg-success text-white',
    'Cancelado' => 'bg-secondary text-white',
];
?>
<!doctype html>
<html lang="es" class="light-theme">

<head>
    <?php include '../general/libreria-css.php'; ?>

    <!-- Dropify (sigue aqu por si la usas en otros modales) -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

    <style>
        /* ====== estilos propios ====== */
        .table-hover tbody tr:hover {
            background: #e8f7ff
        }

        #hover_enlace:hover {
            color: #6f42c1;
            border-radius: .5rem;
            box-shadow: 0 0 .5rem #6f42c180;
        }

        .sticky-thead th {
            position: sticky;
            top: 0;
            z-index: 5;
            background: #fff;
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>

        <div class="page-content-wrapper">
            <div class="page-content">

                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb small mb-0">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"><ion-icon name="home-outline"></ion-icon></a>
                        </li>
                        <li class="breadcrumb-item active">Despachos</li>
                    </ol>
                </nav>

                <!-- Ttulo -->
                <div class="card shadow-sm border-0 mb-4">
                    <div class="card-body text-center bg-gradient-info bg-opacity-75 text-white rounded-3">
                        <h3 class="mb-0 fw-bold">DESPACHOS</h3>
                    </div>
                </div>

                <!-- Contenedor principal -->
                <div class="card shadow-sm">
                    <div class="card-body">

                        <div class="d-flex flex-column flex-sm-row justify-content-between align-items-sm-center mb-3 gap-3">
                            <h6 class="mb-0 text-uppercase fw-bold">Lista de despachos</h6>

                            <!-- Botn nuevo -->
                            <button class="btn btn-success radius-10" data-bs-toggle="modal" data-bs-target="#modalAgregar">
                                <i class="fas fa-plus me-1"></i> Nuevo despacho
                            </button>
                        </div>

                        <!-- Tabla -->
                        <div class="table-responsive">
                            <table id="example2" class="table table-striped table-bordered table-hover align-middle w-100">
                                <thead class=" table-info small">
                                    <tr>
                                        <th class="text-center" style="width:9%">Fecha</th>
                                        <th class="text-center" style="width:10%">N Despacho</th>
                                        <th>Tercero</th>
                                        <th class="text-center">Destino</th>
                                        <th>Direccin</th>
                                        <th>Observacin</th>
                                        <th class="text-center">Cant.</th>
                                        <th class="text-center">Paquetes</th>
                                        <th class="text-center">Estado</th>
                                        <th class="text-center">Detalle</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $q = $conn->query("SELECT * FROM despacho ORDER BY fecha DESC, id DESC");
                                    while ($row = $q->fetch_assoc()):
                                        $cant  = $conn->query("SELECT SUM(cantidad) c FROM despacho_detalle WHERE id_despacho='{$row['id']}'")->fetch_assoc()['c'] ?? 0;
                                        $packs = $conn->query("SELECT SUM(cantidad) c FROM despacho_paquete WHERE id_despacho='{$row['id']}'")->fetch_assoc()['c'] ?? 0;
                                        $badge = $badgeClass[$row['estado']] ?? 'bg-light';
                                    ?>
                                        <tr id="hover_enlace">
                                            <td class="text-center"><?= date('d-m-Y', strtotime($row['fecha'])) ?></td>
                                            <td class="text-center fw-semibold"><?= $row['numero_despacho'] ?></td>
                                            <td><?= $row['nombre_tercero'] ?></td>
                                            <td class="text-center"><?= $row['destino'] ?></td>
                                            <td><?= $row['direccion'] ?></td>
                                            <td><?= $row['observacion'] ?></td>
                                            <td class="text-center"><?= number_format($cant, 0) ?></td>
                                            <td class="text-center"><?= number_format($packs, 0) ?></td>
                                            <td class="text-center"><span class="badge <?= $badge ?>"><?= $row['estado'] ?></span></td>
                                            <td class="text-center">
                                                <a href="despacho-detalle.php?id_despacho=<?= $row['id'] ?>" class="text-dark">
                                                    <i class="fa-solid fa-arrow-right-to-bracket fa-lg"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endwhile ?>
                                </tbody>
                            </table>
                        </div>

                    </div><!-- /.card-body -->
                </div><!-- /.card -->

                <?php echo include '../general/footer.php'; ?>

            </div><!-- /.page-content -->
        </div><!-- /.wrapper-content -->
    </div><!-- /.wrapper -->

    <?php echo include '../general/libreria-js.php'; ?>

    <!-- Modal Nuevo despacho -->
    <div class="modal fade" id="modalAgregar" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-gradient-info text-white">
                    <h5 class="modal-title fw-bold">Nuevo despacho</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <form class=" g-3 needs-validation" method="POST" action="script/despacho-guardar.php" novalidate>
                    <input type="hidden" name="nombre_usuario" value="<?= $rowusu['nombre'] ?? '' ?>">

                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label">Fecha</label>
                                <input type="date" class="form-control" name="fecha" value="<?= date('Y-m-d') ?>" required>
                                <div class="invalid-feedback">Obligatorio</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">N Despacho</label>
                                <input type="text" class="form-control" name="numero_despacho" value="No aplica" required>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label mt-3">Nombre tercero</label>
                                <select class="form-select" name="nombre_tercero" required>
                                    <option value="" disabled selected>Seleccione</option>
                                    <?php
                                    $ter = $conn->query("SELECT nombre FROM tercero ORDER BY nombre");
                                    while ($t = $ter->fetch_assoc()):
                                    ?>
                                        <option value="<?= $t['nombre'] ?>"><?= $t['nombre'] ?></option>
                                    <?php endwhile ?>
                                </select>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label mt-3">Observacin</label>
                                <textarea class="form-control" name="observacion" required>No aplica</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-success radius-10" type="submit">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- DataTables -->
    <script>
        new DataTable('#example2', {
            lengthChange: false,
            buttons: ['copy', 'excel', 'pdf', 'print'],
            autoWidth: false,
            order: [],
            language: {
                search: 'Buscar',
                zeroRecords: 'No hay registros.',
                emptyTable: 'Sin datos.',
                info: 'Mostrando _START_ a _END_ de _TOTAL_',
                infoFiltered: '(filtrado de _MAX_)',
                paginate: {
                    first: 'Primero',
                    previous: 'Anterior',
                    next: 'Siguiente',
                    last: '03ltimo'
                }
            }
        });
    </script>
</body>

</html>