<?php


function obtenerNombreMes($numeroMes) {
    $meses = [
        1 => "ENERO", 2 => "FEBRERO", 3 => "MARZO",
        4 => "ABRIL", 5 => "MAYO", 6 => "JUNIO",
        7 => "JULIO", 8 => "AGOSTO", 9 => "SEPTIEMBRE",
        10 => "OCTUBRE", 11 => "NOVIEMBRE", 12 => "DICIEMBRE"
    ];

    return $meses[$numeroMes] ?? "Mes inválido";
}


function moneda($valor)
{
    return number_format($valor, 0, ',', '.');
}

function formatear_con_estado($valor, $estado)
{
    $valor_formateado = moneda($valor);
    return (in_array($estado, ['Cancelado', 'Devolucion'])) ? "<span>$valor_formateado</span>" : $valor_formateado;
}


function obtenerClasesBadge($estado)
{
    switch ($estado) {
        case 'Proceso':
            return ['text-white', 'bg-info'];
        case 'Confirmado':
            return ['text-white', 'bg-pink'];
        case 'Alistamiento':
            return ['text-white', 'bg-primary'];
        case 'Enviado':
            return ['text-white', 'bg-warning'];
        case 'Novedad':
            return ['text-white', 'bg-bronze'];
        case 'Entregado':
            return ['text-white', 'bg-success'];
        case 'Cancelado':
            return ['text-white', 'bg-secondary'];
        case 'Devolucion':
            return ['text-white', 'bg-dark'];
        case 'Indemnizado':
            return ['text-dark', 'bg-white'];

        // Aquí agregas tus 2 nuevos estados
        case 'Por contestar':
            // Ejemplo: usar un tono de azul claro
            return ['text-white', 'bg-linkedin'];
        case 'No contestado':
            // Ejemplo: usar un tono de azul oscuro
            return ['text-white', 'bg-facebook'];

        default:
            return ['text-dark', ''];
    }
}