<?php
/*  ▸▸  LÓGICA PHP  ▸▸--------------------------------------------------- */
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

/* ────────────────────────── 1. DATOS DEL PEDIDO ─────────────────────── */
$id_pedido = (int)($_GET['id_pedido'] ?? 0);
if ($id_pedido <= 0) {
    die('ID inválido');
}

$pedido   = $conn->query("SELECT * FROM pedido WHERE id='$id_pedido'")->fetch_assoc();
$tercero  = $conn->query("SELECT * FROM tercero WHERE nombre='{$pedido['nombre_tercero']}'")->fetch_assoc();

/* ────────────────────────── 2. TALLAS (cabecera) ─────────────────────── */
$sqlTallas = "
  SELECT talla, SUM(cantidad) AS suma
    FROM pedido_detalle
   WHERE id_pedido = '$id_pedido'
GROUP BY talla
ORDER BY talla ASC";
$resTallas   = $conn->query($sqlTallas);
$tallas      = $resTallas ? $resTallas->fetch_all(MYSQLI_ASSOC) : [];

/* ────────────────────────── 3. DETALLES POR REFERENCIA ──────────────── */
$sqlDetalle = "
  SELECT referencia_producto,
         SUM(cantidad) AS cant_total
    FROM pedido_detalle
   WHERE id_pedido = '$id_pedido'
GROUP BY referencia_producto";
$resDetalle  = $conn->query($sqlDetalle);
$detalles    = $resDetalle ? $resDetalle->fetch_all(MYSQLI_ASSOC) : [];

/* ────────────────────────── 4. TOKEN CSRF ───────────────────────────── */
if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(32));
}
$csrf = $_SESSION['csrf'];

/* ────────────────────────── 5. COLORES PARA EL ESTADO ───────────────── */
$badgeClass = [
    'Proceso'    => 'badge alert-info',
    'Confirmado' => 'badge bg-pink',
    'Recibido'   => 'badge alert-success',
    'Cancelado'  => 'badge alert-secondary',
];

/* 5-B.  CLASES para el icono de estado dentro del menú */
$iconClass = [
    'Proceso'    => 'text-info',
    'Confirmado' => 'text-pink',
    'Recibido'   => 'text-success',
    'Cancelado'  => 'text-secondary',
];

$badgeEstado = $badgeClass[$pedido['estado']] ?? 'badge bg-light';


/*  ▸▸  INICIO HTML  ▸▸--------------------------------------------------- */
?>
<!doctype html>
<html lang="en" class="light-theme">

<head>

    <?php include '../general/libreria-css.php'; ?>

    <style>
        /* -------------  ESTILOS PROPIOS  -------------- */
        .tabla-tallas thead th.sticky-top {
            top: 0;
            z-index: 5;
            background: #fff;
        }

        .tabla-tallas td:first-child,
        .tabla-tallas th:first-child {
            position: sticky;
            left: 0;
            z-index: 4;
            background: #fff;
        }

        #hover_enlace:hover {
            color: #fd7e14;
            border: 1px solid #fd7e14;
            padding: 1px;
            box-shadow: 0 0 .5rem #ffc10780;
        }
    </style>
</head>

<body>
    <!--start wrapper-->
    <div class="wrapper">
        <?php echo include '../general/menu.php'; ?>

        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
            <!-- start page content-->
            <div class="page-content">

                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb" class="mb-3">
                    <ol class="breadcrumb small">
                        <li class="breadcrumb-item"><a href="../inicio/inicio.php"><ion-icon name="home-outline"></ion-icon></a></li>
                        <li class="breadcrumb-item"><a href="pedido.php">Pedidos</a></li>
                        <li class="breadcrumb-item active">ODP-<?= $id_pedido ?> <?= $pedido['nombre_tercero'] ?></li>
                    </ol>
                </nav>



                <!-- Cabecera -->
                <!-- Cabecera -->
                <div class="card shadow-sm mb-4 border-0">
                    <div class="card-body bg-gradient-warning bg-opacity-75 rounded-3">
                        <div class="d-flex flex-column flex-sm-row justify-content-between align-items-sm-center gap-3">
                            <h1 class="h4 mb-0 text-dark fw-bold">ODP-<?= $id_pedido ?></h1>

                            <!-- Estado -->
                            <div class="dropdown">
                                <button class="btn <?= $badgeEstado ?> dropdown-toggle py-2 px-3 text-uppercase"
                                    data-bs-toggle="dropdown">
                                    <?= $pedido['estado'] ?>
                                </button>

                                <ul class="dropdown-menu dropdown-menu-end shadow-sm">
                                    <?php foreach ($badgeClass as $estado => $clase): ?>
                                        <li>
                                            <form action="script/pedido-estado-editar.php"
                                                method="post"
                                                class="dropdown-item p-0"
                                                <?= $estado === 'Cancelado' ? 'onsubmit="return confirm(\'¿Cancelar pedido?\')"' : '' ?>>
                                                <input type="hidden" name="id_pedido" value="<?= $id_pedido ?>">
                                                <input type="hidden" name="estado" value="<?= $estado ?>">
                                                <input type="hidden" name="csrf" value="<?= $csrf ?>">
                                                <button class="w-100 border-0 bg-transparent py-2 text-start">
                                                    <i class="fas fa-circle <?= $iconClass[$estado] ?> me-2"></i><?= $estado ?>
                                                </button>
                                            </form>
                                        </li>
                                    <?php endforeach ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>




                <!-- Área imprimible -->
                <div class="card shadow-sm" id="areaImprimir">
                    <div class="card-body">

                        <!-- Info cliente -->
                        <div class="row align-items-center mb-4 gx-4">
                            <div class="col-md-8">
                                <h2 class="h6 text-uppercase mb-0">Cliente: <span class="text-dark fw-bold"><?= $pedido['nombre_tercero'] ?></span></h2>
                                <small class="text-muted">Tel: <?= $tercero['telefono'] ?></small>
                            </div>
                            <div class="col-md-4 text-md-end">
                                <span class="badge bg-light text-dark fs-6"><?= $pedido['fecha'] ?></span>
                            </div>
                        </div>

                        <!-- Datos generales del pedido -->
                        <div class="table-responsive mb-4">
                            <table class="table table-bordered table-sm">
                                <thead class="bg-gradient-warning text-dark">
                                    <tr>
                                        <th style="width:5%" class="text-center">Logo</th>
                                        <th style="width:30%" class="text-center">Datos</th>
                                        <th style="width:40%" class="text-center">Observación</th>
                                        <th style="width:10%" class="text-center">N° Pedido</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="align-middle">
                                        <td class="text-center"><img src="../../img/logo.png" width="60" loading="lazy" alt="logo"></td>
                                        <td>
                                            <span class="fw-semibold">Cliente:</span> <mark><?= $pedido['nombre_tercero'] ?></mark><br>
                                            <span class="fw-semibold">Tel:</span> <mark><?= $tercero['telefono'] ?></mark>
                                        </td>
                                        <td><mark><?= $pedido['observacion'] ?></mark></td>
                                        <td class="text-center fs-4 fw-bold"><?= $pedido['numero_pedido'] ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        
                          <div class="row d-print-none ">
                            <div class="col-xl-6">
                            </div>
                            <div class="col-xl-6 text-end">

                                <?php
                                if ($pedido['estado'] == 'Proceso') {
                                ?>

                                    <a class="btn btn-warning px-5 radius-30" href="#!" data-bs-toggle="modal" data-bs-target="#editar_venta">
                                        <i class="far fa-edit me-2"></i>Actualizar datos
                                    </a>

                                <?php
                                } else {
                                }
                                ?>

                                <div class="modal fade" id="editar_venta" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-xs">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar pedido</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <form class=" g-3 needs-validation text-start" novalidate="" method="POST" action="script/pedido-editar.php">
                                                <input class="form-control" type="text" required="" name="id_pedido" value="<?php echo $id_pedido; ?>" hidden>
                                                <input class="form-control" type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>


                                                <div class="modal-body ">
                                                    <div class="row">
                                                        <div class="col-md-12">

                                                            <style>
                                                                .inputcss {
                                                                    color: brown;
                                                                    font-weight: 500;
                                                                }
                                                            </style>


                                                            <?php
                                                            if ($pedido['estado'] != 'Proceso') {
                                                                $readonly = '';
                                                            } else {
                                                                $readonly = '';
                                                            }
                                                            ?>


                                                            <div class="row ">
                                                                <div class="col-md-6">
                                                                    <label class="form-label" for="validationCustom01">Fecha:</label>
                                                                    <input class="form-control inputcss" type="date" name="fecha" value="<?php echo $pedido['fecha']; ?>" <?php echo $readonly; ?> required="">

                                                                </div>

                                                                <div class="col-md-6">
                                                                    <label class="form-label" for="validationCustom02">No Pedido:</label>
                                                                    <input class="form-control inputcss " type="text" required="" name="numero_pedido" value="<?php echo $pedido['numero_pedido']; ?>" <?php echo $readonly; ?>>

                                                                </div>


                                                            
                                                                    <div class="col-md-12 mt-3">
                                                                        <label class="form-label" for="validationCustom01">Nombre tercero:</label>


                                                                        <select class="form-select custom-select-modal" required="" name="nombre_tercero" <?php echo $readonly; ?>>
                                                                            <option value="<?php echo $pedido['nombre_tercero']; ?>"><?php echo $pedido['nombre_tercero']; ?></option>
                                                                            <option disabled="" value="">Seleccione</option>
                                                                            <option value="VARIOS">VARIOS</option>
                                                                            <?php
                                                                            $sql6m = "SELECT * FROM tercero ORDER BY nombre asc";
                                                                            $query6m = $conn->query($sql6m);
                                                                            if ($query6m->num_rows > 0) {
                                                                                while ($row6m = $query6m->fetch_assoc()) {
                                                                                    ?>

                                                                                    <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                                    <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                        </select>


                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                        <div class="invalid-feedback">Por favor, seleccione un tipo de venta.</div>
                                                                    </div>




                                                                <div class="col-md-12 mt-3">
                                                                    <label class="form-label" for="validationCustom02">Observaci n:</label>
                                                                    <textarea class="form-control inputcss" type="text" required="" name="observacion" placeholder="Complemento para direccion u observacion" <?php echo $readonly; ?>><?php echo $pedido['observacion']; ?></textarea>

                                                                </div>

                                                            </div>
                                                        </div>



                                                    </div>


                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-warning px-5 radius-30">Guardar cambios</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                            </div>

                                      
                        </div>
                        

                        <!-- Tabla referencias + tallas -->
                        <div class="table-responsive table-responsive-lg">
                            <table class="table table-hover table-bordered table-sm tabla-tallas">
                                <thead class="text-dark bg-warning bg-opacity-75 small sticky-top">
                                    <tr>
                                        <th>Foto</th>
                                        <th>Referencia</th>
                                        <th class="text-center">Categoría</th>
                                        <th class="text-center">Color</th>
                                        <?php foreach ($tallas as $t): ?>
                                            <th class="text-center"><?= $t['talla'] ?></th>
                                        <?php endforeach ?>
                                        <th class="text-center">Pares</th>
                                    </tr>
                                </thead>
                                <tbody class="align-middle">
                                    <?php $total_cant = 0; ?>
                                    <?php foreach ($detalles as $det):
                                        $prod = $conn->query("SELECT * FROM producto WHERE referencia='{$det['referencia_producto']}'")->fetch_assoc(); ?>
                                        <tr>
                                            <td class="text-center">
                                                <img src="<?= $prod['foto1'] == 'NO APLICA' ? '../../img/camara.jpg' : '../../img-producto/' . $prod['foto1'] ?>"
                                                    width="40" height="40" loading="lazy">
                                            </td>
                                            <td>
                                                <span class="fw-semibold"><?= $prod['referencia'] ?></span>
                                                <?php if ($pedido['estado'] == 'Proceso'): ?>
                                                    <a class="btn btn-warning btn-sm float-end" data-bs-toggle="modal"
                                                        data-bs-target="#editar_referencia"
                                                        data-id_pedido="<?= $id_pedido ?>"
                                                        data-referencia_producto="<?= $det['referencia_producto'] ?>">
                                                        Editar
                                                    </a>
                                                <?php endif ?>
                                            </td>
                                            <td class="text-center text-muted small"><?= $prod['categoria'] ?></td>
                                            <td class="text-center text-muted small"><?= $prod['color'] ?></td>

                                            <?php foreach ($tallas as $t):
                                                $cantTalla = $conn->query("SELECT SUM(cantidad) AS suma
                                                        FROM pedido_detalle
                                                    WHERE id_pedido='$id_pedido'
                                                        AND referencia_producto='{$det['referencia_producto']}'
                                                        AND talla='{$t['talla']}'")->fetch_assoc()['suma'] ?? ''; ?>
                                                <td class="text-center">
                                                    <?php if ($pedido['estado'] != 'Proceso'): ?>
                                                        <?= $cantTalla ?>
                                                    <?php else: ?>
                                                        <form action="script/pedido-talla-eliminar.php"
                                                            method="post" class="d-inline"
                                                            onsubmit="return confirm('¿Eliminar?');">
                                                            <input type="hidden" name="id_pedido" value="<?= $id_pedido ?>">
                                                            <input type="hidden" name="referencia_producto" value="<?= $det['referencia_producto'] ?>">
                                                            <input type="hidden" name="talla" value="<?= $t['talla'] ?>">
                                                            <input type="hidden" name="csrf" value="<?= $csrf ?>">
                                                            <button class="btn btn-link p-0 text-dark fw-semibold">
                                                                <span id="hover_enlace"><?= $cantTalla ?></span>
                                                            </button>
                                                        </form>
                                                    <?php endif ?>
                                                </td>
                                            <?php endforeach ?>

                                            <td class="text-center fw-bold"><?= $det['cant_total']; ?></td>
                                        </tr>
                                    <?php $total_cant += $det['cant_total'];
                                    endforeach ?>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-light">
                                        <th colspan="<?= count($tallas) + 4 ?>" class="text-end">TOTAL</th>
                                        <th class="text-center"><?= $total_cant ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>



     <?php
                            if ($pedido['estado'] == 'Proceso') {
                                ?>

                                <form class=" g-3 needs-validation d-print-none" method="POST" action="script/pedido-referencia-guardar.php">
                                    <input class="form-control inputcss "   type="text" required="" name="id_pedido" value="<?php echo $id_pedido; ?>" hidden >
                                    <input class="form-control inputcss "   type="text" required="" name="estado" value="<?php echo $pedido['estado']; ?>" hidden>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <select class="" id="single-select1" required="" name="referencia_producto" autofocus="">
                                                <?php
                                                if (isset($_GET['referencia_producto'])) {
                                                    ?>
                                                    <option selected=""  value="<?php echo $_GET['referencia_producto']; ?>"><?php echo $_GET['referencia_producto']; ?></option>
                                                    <option value="">Referencias</option>
                                                    <?php
                                                } else {
                                                    ?>
                                                    <option selected=""  value="">Referencias</option>
                                                    <?php
                                                }
                                                $sql4 = "SELECT * FROM producto WHERE Habilitado='Si'";
                                                $query4 = $conn->query($sql4);
                                                if ($query4->num_rows > 0) {
                                                    while ($row4 = $query4->fetch_assoc()) {
                                                        ?>
                                                        <option value="<?php echo $row4['referencia'] ?>" ><?php echo $row4['referencia'] ?> - <?php echo $row4['color']; ?> <?php echo $row4['categoria']; ?>
                                                            <?php
                                                        }
                                                    }
                                                    ?>

                                            </select>

                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, seleccione referencia.</div>
                                        </div>


                                        <div class="col-md-2">
                                            <select class="custom-select" id="validationCustom04" required="" name="talla">
                                                <option selected="" disabled="" value="">Tallas</option>
                                                <?php
                                                for ($i = 10; $i < 50; $i++) {
                                                    ?>
                                                    <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, seleccione talla.</div>
                                        </div>
                                        <div class="col-md-2">
                                            <input class="form-control inputcss "   type="number" required="" name="cantidad" placeholder="cant." value="0">
                                            <div class="valid-feedback">Se ve bien!</div>
                                            <div class="invalid-feedback">Por favor, Digite cantidad de prendas.</div>
                                        </div>
                                        <div class="col-md-2">
                                            <button class="btn btn-success px-2 radius-30" style="width: 100%;" type="submit"><i class="fas fa-plus text-white"></i> Agregar Item</button>
                                        </div>
                                    </div> 
                                </form>

                                <!-- FIN TABA-->
                                <?php
                            } else {
                                
                            }
                            ?>


                        <!-- Botón imprimir -->
                        <div class="text-center my-4 d-print-none">
                            <button class="btn btn-info btn-lg radius-30" onclick="printDiv('areaImprimir')">
                                <i class="fas fa-print"></i> Imprimir
                            </button>
                        </div>


                    </div><!-- /.card-body -->
                </div><!-- /.card -->

            </div><!-- /.page-content -->
            <?php echo include '../general/footer.php'; ?>
        </div><!-- /.wrapper -->
    </div>

    <?php echo include '../general/libreria-js.php'; ?>
    <script>
        //Tabla producto
        $(document).ready(function() {
            var select1 = $('#single-select1').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),
            });


        });
    </script>

    <div class="modal fade" id="editar_referencia" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title card-heading" id="exampleModalLabel">EDITA REFERENCIA</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/referencia-editar.php">
                    <input class="form-control" type="text" required="" name="edit_id_pedido" id="edit_id_pedido" hidden="">

                    <div class="modal-body ">
                        <div class="row ">
                            <div class="col-md-12 mb-3">
                                <label class="form-label" for="validationCustom01">Referencia actual:</label>
                                <input class="form-control" type="text" required="" name="edit_referencia_producto" id="edit_referencia_producto" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite la referencia.</div>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label" for="validationCustom01">Referencia nueva:</label>
                                <select class="form-control" id="" required="" name="edit_referencia_producto_new">
                                    <option selected="" value="">Referencias</option>
                                    <?php
                                    $sql4 = "SELECT * FROM producto WHERE Habilitado='Si'";
                                    $query4 = $conn->query($sql4);
                                    if ($query4->num_rows > 0) {
                                        while ($row4 = $query4->fetch_assoc()) {
                                    ?>
                                            <option value="<?php echo $row4['referencia'] ?>"><?php echo $row4['referencia'] ?> - <?php echo $row4['color']; ?> <?php echo $row4['categoria']; ?>
                                        <?php
                                        }
                                    }
                                        ?>

                                </select>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite precio actual.</div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" name="eliminar" class="btn btn-danger radius-10">Eliminar</button>
                        <button type="submit" name="editar" class="btn btn-warning radius-10">Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // PASO DE PARAMETROS EDITAR
        $('#editar_referencia').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget) // Button that triggered the modal

            var id_pedido = button.data('id_pedido')
            var referencia_producto = button.data('referencia_producto')


            $('#edit_id_pedido').val(id_pedido)
            $('#edit_referencia_producto').val(referencia_producto)
        });
    </script>



</body>

</html>