<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$id_nomina = $_GET['id_nomina'];

$sql1 = "SELECT * FROM nomina WHERE id=$id_nomina";
$query1 = $conn->query($sql1);
$row1 = $query1->fetch_assoc();

$fecha_desde = $row1['fecha_desde'];
$fecha_hasta = $row1['fecha_hasta'];
$nombre_usuario = $row1['nombre_usuario'];
$comision = $row1['porciento'];
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="nomina.php"> 
                                    Nomina asesores
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="nomina-asesor.php?nombre_usuario=<?php echo $nombre_usuario;?>"> 
                                    <?php echo $nombre_usuario; ?>                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Reporte de comision</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center">
                            <h5><?php echo $fecha_desde; ?> <b>al</b> <?php echo $fecha_hasta; ?></h5>
                            <span class="badge bg-success">Entregado</span><br>
                            <span><b>Comision:</b> <?php echo $comision ?> %</span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table align-middle mb-0 table-striped" id="example2" style="font-size: 12px;">
                                            <thead class="table-light">
                                                <tr class="bg-light-primary text-primary">
                                                    <th class="text-center">Id</th>
                                                    <th class="text-center">Fecha</th>
                                                    <th class="text-center">Cliente</th>
                                                    <th class="text-center">Destino</th>     
                                                    <th class="text-center">Flete cliente</th>
                                                    <th class="text-center">Total venta</th>
                                                    <th class="text-center">Flete empresa</th>
                                                    <th class="text-center">Abono flete</th>
                                                    <th class="text-center">Total recaudo</th>
                                                    <th class="text-center">Comision</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $to_comision = 0;
                                                $to_recaudo = 0;
                                                $sql = "SELECT * FROM venta WHERE fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND nombre_usuario='$nombre_usuario' AND estado='Entregado'";
                                                $query = $conn->query($sql);
                                                if ($query->num_rows > 0) {
                                                    while ($row = $query->fetch_assoc()) {
                                                        ?>
                                                        <tr> 
                                                            <td class="">
                                                                <a href="../venta/venta-detalle.php?id_venta=<?php echo $row['id']; ?>" target="_blank">
                                                                    <b>
                                                                        ODP <?php echo $row['id']; ?>
                                                                    </b>
                                                                </a>
                                                            </td>
                                                            <td class="text-center"><?php echo $row['fecha']; ?></td>
                                                            <td class="">
                                                                <i class="fas fa-user"></i>
                                                                <?php echo $row['nombre']; ?> 
                                                            </td> 
                                                            <td class="">
                                                                <i class=" fas fa-map-marker-alt"></i>
                                                                <?php echo $row['destino']; ?>
                                                            </td>
                                                            <td class="text-end">
                                                                <?php echo number_format($row['flete_cliente'], 0); ?>
                                                            </td>
                                                            <td class="text-end">
                                                                <?php echo number_format($row['total_venta'], 0); ?> <i class="fas fa-plus-circle text-success"></i>
                                                            </td>
                                                            <td class="text-end">
                                                                <?php echo number_format($row['flete_empresa'], 0); ?> <i class="fas fa-minus-circle text-danger"></i>
                                                            <td class="text-end">
                                                                <?php echo number_format($row['abono_flete'], 0); ?> <i class="fas fa-plus-circle text-success"></i>
                                                            </td>                   
                                                            <td class="text-end">
                                                                <?php
                                                                $total_recaudado = $row['total_venta'] - $row['flete_empresa'] + $row['abono_flete'];
                                                                ?>
                                                                <?php echo number_format($total_recaudado, 0); ?> <i class="fas fa-circle text-info"></i>

                                                            </td>
                                                            <td class="text-end">             
                                                                <?php
                                                                $total_comision = $total_recaudado * $comision / 100;
                                                                ?>
                                                                <b class="text-info"><?php echo number_format($total_comision, 0); ?></b>
                                                            </td>

                                                        </tr>
                                                        <?php
                                                        $to_recaudo += $total_recaudado;
                                                        $to_comision += $total_comision;
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                            <tfoot>
                                                <tr class="bg-light-dark">
                                                    <th colspan="8" class="text-end ">TOTAL</th>
                                                    <th class="text-end ">$ <?php echo number_format($to_recaudo, 0); ?></th>
                                                    <th class="text-end ">$ <?php echo number_format($to_comision, 0); ?></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>