<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <div class="container-fluid p-5 ">

            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Produccion</li>
                    </ol>
                </nav>

                <div class="card d-print-none">
                    <div class="card-body text-center">
                        <h3><b> PRODUCCION POR FECHA</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-produccion.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2 ">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">


                        <style>
                            th, td { white-space: nowrap; }

                            div.dataTables_wrapper {
                                width: 100%;
                                margin: 0 auto;
                            }


                        </style>




                        <?php
                        if (isset($_GET['filtro'])) {

                            $fecha_desde = $_GET['fecha_desde'];
                            $fecha_hasta = $_GET['fecha_hasta'];

                            $sql_fecha = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";

                            $sql = $sql_fecha;
                            ?>
                            <div class=" mt-3">
                                <div class="d-print-none">
                                    <div class="float-end">
                                        <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>


                                <div class="p-2 rounded">




                                    <div class="row">
                                        <div class="col-sm-2 text-center">
                                            <img src="../../img/logo.png" class="logo-icon"  alt="logo icon" width="80">

                                        </div> 

                                        <div class="col-sm-8 text-start">
                                            <h6 class="text-dark mt-0 mb-1"><b>REPORTE DE PRODUCCION</b></h6>


                                            <h6 class="text-dark mt-0 mb-0">
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> 
                                                <b class="ms-3 me-3">|</b> 
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>
                                            </h6> 

                                        </div>
                                    </div>
                                </div>

                                <style>
                                    #hover_enlace:hover{
                                        color: purple;
                                        border-radius: 10px; 
                                        box-shadow: 0px 0px 10px 0px purple;
                                    }



                                </style>


                                <div class=" mt-2 table-responsive" >
                                    <table class="table align-middle mb-0 table-striped table-bordered table-sm" border="1" id="example2" style="">
                                        <thead class="">
                                            <tr class="bg-gradient-purple text-white">
                                                <th class="text-center" style="width: 8%;">FECHA</th>
                                                <th class="text-center" style="width: 14%;">USUARIO DE REGISTRO</th>

                                                <th class="text-center ">No</th>
                                                <th class=" " style="width: 15%;">ENCARGADO</th>
                                                <th class="text-center">MATERIAL</th>
                                                <th class="text-center">CANT.</th>
                                                <th class="text-center">COMISION</th>
                                                <th class="text-center">A PAGAR</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_pares = 0;
                                            $total_pagar = 0;
                                            $sql = "SELECT * FROM produccion WHERE $sql  ORDER BY fecha desc";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {

                                                    $sql1 = "SELECT SUM(cantidad) as cantidad FROM produccion_detalle WHERE id_produccion='" . $row['id'] . "'";
                                                    $query1 = $conn->query($sql1);
                                                    $row1 = $query1->fetch_assoc();

                                                    $sql2 = "SELECT p.categoria "
                                                            . "FROM produccion_detalle pd, producto p "
                                                            . "WHERE p.referencia=pd.referencia_producto AND id_produccion='" . $row['id'] . "' GROUP BY p.categoria ";
                                                    $query2 = $conn->query($sql2);
                                                    $row2 = $query2->fetch_assoc();

                                                    if (isset($row['nombre_tercero_1'])) {
                                                        $encargado = 1;
                                                    } else {
                                                        $encargado = 0;
                                                    }

                                                    if (isset($row['nombre_tercero_2'])) {
                                                        $ayudante_1 = 1;
                                                    } else {
                                                        $ayudante_1 = 0;
                                                    }

                                                    if (isset($row['nombre_tercero_3'])) {
                                                        $ayudante_2 = 1;
                                                    } else {
                                                        $ayudante_2 = 0;
                                                    }


                                                    $total_operarios = $encargado + $ayudante_1 + $ayudante_2;

                                                    if (isset($row2['categoria'])) {
                                                        $material = $row2['categoria'];

                                                        if ($row2['categoria'] == 'EXPANSO') {
                                                            if ($total_operarios > 1) {
                                                                $comision = 7;
                                                            } elseif ($total_operarios == 1) {
                                                                $comision = 10;
                                                            } else {
                                                                $comision = 0;
                                                            }
                                                        } elseif ($row2['categoria'] == 'PVC') {
                                                            if ($total_operarios > 0) {
                                                                $comision = 6;
                                                            } else {
                                                                $comision = 0;
                                                            }
                                                        }
                                                    } else {
                                                        $material = '';
                                                    }


                                                    if (isset($row1['cantidad'])) {
                                                        $cantidad = $row1['cantidad'];
                                                    } else {
                                                        $cantidad = 0;
                                                    }




                                                    $pagar = $cantidad * $comision;
                                                    ?>
                                                    <tr class="align-middle" id="hover_enlace" >
                                                        <td class="text-center">
                                                            <b class="text-dark"><?php echo date('d-m-Y', strtotime($row['fecha'])); ?></b>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php echo $row['nombre_usuario']; ?>
                                                        </td>
                                                        <td class="text-center text-primary">
                                                            <b><?php echo $row['numero_produccion']; ?></b>
                                                        </td>  
                                                        <td class="">

                                                            <?php
                                                            echo "<b>" . $row['nombre_tercero_1'] . "</b> <br>";

                                                            if ($row['nombre_tercero_2'] == NULL) {
                                                                
                                                            } else {
                                                                echo "<b class='text-secondary' style='font-size: 11px;'>" . $row['nombre_tercero_2'] . "</b>";
                                                            }
                                                            ?>
                                                            <br>
                                                            <?php
                                                            if ($row['nombre_tercero_3'] == NULL) {
                                                                
                                                            } else {
                                                                echo $row['nombre_tercero_3'];
                                                            }
                                                            ?>


                                                        </td> 
                                                        <td class="text-center" >
                                                            <?php echo $material; ?>
                                                        </td>
                                                        <td class="text-center">
                                                            <b><?php echo number_format($row1['cantidad'], 0); ?></b>
                                                        </td>
                                                        <td class="text-center ">
                                                            <b class="text-info">$</b> <b><?php echo number_format($comision, 0); ?></b>
                                                        </td>
                                                        <td class="text-end h6">
                                                            <b class="float-start text-secondary">$</b> <b class="text-primary"><?php echo number_format($pagar, 0); ?></b>
                                                        </td>


                                                    </tr>
                                                    <?php
                                                    $total_pares += $row1['cantidad'];
                                                    $total_pagar += $pagar;
                                                }
                                            }
                                            ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-light-dark h5">
                                                <td class="text-end" colspan="5"><b>TOTAL</b></td>
                                                <td class="text-center"><b><?php echo number_format($total_pares, 0); ?></b></td>
                                                <td></td>
                                                <td class="text-end">
                                                    <b class="float-start text-secondary">$</b><b><?php echo number_format($total_pagar, 0); ?></b>
                                                </td>
                                            </tr>

                                        </tfoot>
                                    </table>
                                </div>



                            </div>
                            <?php
                        } else {
                            
                        }
                        ?>


                    </div>
                </div>
            </div>

        </div>


        <?php echo include '../general/libreria-js.php'; ?>
        <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    paging: false,
                    lengthChange: false,
                    "columnDefs": [
                        {"orderable": false, "targets": "_all"}, // Desactiva ordenamiento para todas las columnas
                    ],

                    order: [[7, 'desc']],

                    buttons: [
                        {
                            extend: 'excel',
                            text: 'EXCEL',
                            filename: 'PRODUCCION POR FECHA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            filename: 'PRODUCCION POR FECHA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        }
                    ],

                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>


    </body>
</html>