
<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active">                     
                                Consultar
                            </li> 
                        </ol>
                    </nav>



                    <!-- end page title -->
                    <style>
                        #hover_enlace:hover{
                            color: orange;
                            border-radius: 10px; border: #3fc3ee 1px solid;
                            box-shadow: 0px 0px 5px 0px #3fc3ee;
                        }

                    </style>

                    <div class="card bg-gradient-warning">
                        <div class="card-body">

                            <h3 class=""><b class="">PEDIDOS</b> <b class="float-end">PANEL DE IMPRESION</b></h3>
                        </div>
                    </div>


                    <!-- CONTENIDO DE PAGINA-->
                    <section class="mb-3 mb-lg-5">


                        <div class="card-box">
                            <hr class="" style="border-top: 2px dotted orange;">
                            <div class="row mb-2">
                                <div class="col-sm-4">
                                    <a href="#">
                                        <div class="alert alert-success fade show mb-0 ">
                                            <strong class="alert-heading">PASO 1:</strong> Selecionar ventas a imprimir.
                                        </div>
                                    </a>
                                </div>
                                <div class="col-sm-4">
                                    <a href="confirmacion.php">
                                        <div class="alert alert-warning fade show mb-0 ">
                                            <strong class="alert-heading">PASO 2:</strong> Confirmar ventas a imprimir.
                                        </div>
                                    </a>
                                </div>
                                <div class="col-sm-4">
                                    <a href="impresion.php">
                                        <div class="alert alert-warning fade show mb-0 ">
                                            <strong class="alert-heading">PASO 3:</strong> Imprimir ventas seleccionadas.
                                        </div>
                                    </a>
                                </div>
                            </div>

                            <?php
                            if (isset($_GET['filtro'])) {
                                $fecha_desde = $_GET['fecha_desde'];
                                $fecha_hasta = $_GET['fecha_hasta'];
                                $estado = $_GET['estado'];
                            } else {
                                $fecha_desde = date("Y-m-d");
                                $fecha_hasta = date("Y-m-d");
                            }
                            ?>

                            <form method="get" action="consultar.php" class="p-2 mb-4 d-print-none" style="background-color: #e8eff7;">
                                <div class="row">
                                    <div class="col-6 col-sm-2">
                                        <div class="form-group">
                                            <label>Desde</label>
                                            <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-2">
                                        <div class="form-group">
                                            <label>Hasta</label>
                                            <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                        </div>
                                    </div>
                                    <div class="col-6 col-sm-2">
                                        <div class="form-group">
                                            <label>Estado</label>
                                            <select class="form-control form-control-sm" name="estado" required>

                                                <?php
                                                if (isset($_GET['filtro'])) {

                                                    if ($estado != 'todo') {
                                                        ?>
                                                        <option value="<?php echo $estado; ?>"><?php echo $estado; ?></option>
                                                        <option value="" disabled=""></option>
                                                        <option value="todo">Todos</option>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <option value="todo">Todos</option>
                                                        <option value="" disabled=""></option>
                                                        <?php
                                                    }
                                                } else {
                                                    ?>
                                                    <option value="todo">Todos</option>
                                                    <option value="" disabled=""></option>
                                                    <?php
                                                }
                                                ?>
                                                <option value="Proceso">Proceso</option>
                                                <option value="Cancelado">Cancelado</option>
                                                <option value="Confirmado">Confirmado</option>
                                                <option value="Alistamiento">Alistamiento</option>
                                                <option value="Enviado">Enviado</option>
                                                <option value="Novedad">Novedad</option>
                                                <option value="Entregado">Entregado</option>
                                                <option value="Devolucion">Devolucion</option>
                                            </select>  
                                        </div>
                                    </div>
                                    <div class="col-5 col-sm-1 pt-3">
                                        <div class="form-group">
                                            <button class="btn btn-primary m-t-10 radius-30 px-5" type="submit" name="filtro" >
                                                Consultar
                                            </button>  
                                        </div>
                                    </div>
                                </div>
                            </form>


                            <section class="mb-3 mb-lg-5">

                                <?php
                                if (isset($_GET['filtro'])) {

                                    $fecha_desde = $_GET['fecha_desde'];
                                    $fecha_hasta = $_GET['fecha_hasta'];
                                    $estado = $_GET['estado'];

                                    if ($estado == 'todo') {
                                        $sql = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                    } else {
                                        $sql = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' AND estado='" . $estado . "'";
                                    }
                                    ?>


                                    <div class="card card-table mb-4">
                                        <div class="card-header">
                                            <a href="script/consultar-cargar-todo.php?fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>&&estado=<?php echo $estado; ?>&&filtro=<?php echo $_GET['filtro'] ?>" 
                                               class="btn  btn-success btn-sm"
                                               onclick="if (!confirm('Seguro deseas cargar todo al panel de impresion?')) {
                                                               return false

                                                           }">
                                                Cargar resultado de consulta para impresion
                                            </a>
                                        </div>

                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <table class="table table-striped table-bordered" id="datatable1" >
                                                    <thead>
                                                        <tr class="bg-gradient-warning text-dark">
                                                            <th class="text-center p-1" >ID PEDIDO</th>
                                                            <th class="text-center p-1" >FECHA</th>
                                                            <th class="text-center p-1" >TERCERO</th>
                                                            <th class="text-center p-1" >NUMERO PEDIDO</th>
                                                            <th class="text-center p-1" >OBSERVACION</th>
                                                            <th class="text-center p-1" >TOTAL PARES</th>
                                                            <th class="text-center p-1" >ESTADO</th>
                                                            <th class="text-center p-1" >CARGAR PARA IMPRESION</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                        $sql = "SELECT * FROM pedido WHERE $sql";
                                                        $query = $conn->query($sql);
                                                        if ($query->num_rows > 0) {
                                                            while ($row = $query->fetch_assoc()) {
                                                                ?>


                                                                <tr class="align-middle">
                                                                    <td class="text-center">
                                                                        <strong>
                                                                            <a href="../pedido/pedido-detalle.php?id_pedido=<?php echo $row['id']; ?>" style="text-decoration: underline;" target="_blank" class="text-bayk">
                                                                                ODP-<?php echo $row['id']; ?>
                                                                            </a>
                                                                        </strong>
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <?php echo $row['fecha'] ?>
                                                                    </td>
                                                                    <td>
                                                                      <?php echo $row['nombre_tercero']; ?>
                                                                    </td>
                                                                    <td class="text-center">
                                                                        <?php echo $row['numero_pedido']; ?>
                                                                    </td>
                                                                    <td class="">
                                                                        <?php echo $row['observacion']; ?>
                                                                    </td>
                                                                    <td class="text-center">

                                                                        <?php
                                                                        $sql1 = "SELECT SUM(cantidad) as cantidad FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "'";
                                                                        $query1 = $conn->query($sql1);
                                                                        $row1 = $query1->fetch_assoc();
                                                                        ?>

                                                                        <?php echo $row1['cantidad']; ?>
                                                                    </td>
                                                                    <td class="text-center" style="min-width: 125px;">
                                                                        <?php
                                                                        if ($row['estado'] == 'Proceso') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-info';
                                                                        } elseif ($row['estado'] == 'Confirmado') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-pink';
                                                                        } elseif ($row['estado'] == 'Alistamiento') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-primary';
                                                                        } elseif ($row['estado'] == 'Enviado') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-warning';
                                                                        } elseif ($row['estado'] == 'Novedad') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-bronze';
                                                                        } elseif ($row['estado'] == 'Entregado') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-success';
                                                                        } elseif ($row['estado'] == 'Finalizado') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-primary';
                                                                        } elseif ($row['estado'] == 'Cancelado') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-secondary';
                                                                        } elseif ($row['estado'] == 'Devolucion') {
                                                                            $alert_text = 'text-white';
                                                                            $alert = 'bg-dark';
                                                                        } else {
                                                                            $text = 'text-dark';
                                                                        }
                                                                        ?>
                                                                        <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>

                                                                    </td>

                                                                    <td class="text-center">

                                                                        <?php
                                                                        if ($row['panel_impresion'] == 'No') {
                                                                            ?>
                                                                            <a href="script/consultar-cargar-deshacer.php?accion=cargar&&id_pedido=<?php echo $row['id']; ?>&&fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>&&estado=<?php echo $estado; ?>&&filtro=<?php echo $_GET['filtro'] ?>"
                                                                               class="text-success">
                                                                                <strong>
                                                                                    Cargar para impresion
                                                                                </strong>
                                                                            </a>
                                                                            <?php
                                                                        } else {
                                                                            ?>
                                                                            Listo para imprimir - 
                                                                            <a href="script/consultar-cargar-deshacer.php?accion=deshacer&&id_pedido=<?php echo $row['id']; ?>&&fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>&&estado=<?php echo $estado; ?>&&filtro=<?php echo $_GET['filtro'] ?>"
                                                                               class="text-dark">

                                                                                <strong class="text-danger">
                                                                                    Deshacer
                                                                                </strong>
                                                                            </a>
                                                                            <?php
                                                                        }
                                                                        ?>


                                                                    </td>
                                                                </tr>

                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>


                                        <div class="row p-3">

                                            <div class="col-12 text-end">
                                                <a href="confirmacion.php" class="btn  btn-info">Continuar</a>
                                            </div>
                                        </div>

                                    </div>





                                    <?php
                                } else {
                                    ?>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <h5> No hay resultados para mostrar</h5>
                                        </div>
                                    </div>

                                    <?php
                                }
                                ?>


                            </section>


                        </div>
                    </section>

                </div><!-- end col -->
                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

    </body>
</html>


