<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Compras</li>
                        </ol>
                    </nav>


                    <div class="row">
                        <div class="col-xl-4 mx-auto">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Nueva compra</h6>
                                    <hr/>
                                    <div class="p-4 border rounded">
                                        <form method="POST" action="script/compra-guardar.php" class="row g-3 needs-validation ">
                                            <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                            <div class="col-md-6">
                                                <label class="form-label" for="validationCustom02">Fecha</label>
                                                <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="validationCustom02">Numero factura</label>
                                                <input class="form-control" id="validationCustom02" type="text" required="" name="numero_factura">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                <select class="single-select" id="validationCustom04" required="" name="nombre_tercero">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    $sql6m = "SELECT * FROM tercero";
                                                    $query6m = $conn->query($sql6m);
                                                    if ($query6m->num_rows > 0) {
                                                        while ($row6m = $query6m->fetch_assoc()) {
                                                            ?>

                                                            <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                            </div>
                                            <div class="col-md-12 mb-3">
                                                <label class="form-label" for="validationCustom02">Descripcion</label>
                                                <textarea class="form-control" id="validationCustom02" type="text" required="" name="descripcion">No aplica</textarea>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>
                                            <div class="col-12 text-end">
                                                <button class="btn btn-primary" type="submit">Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-8">

                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Lista de compras</h6>
                                    <hr/>

                                    <style>
                                        #hover_enlace:hover{
                                            color: purple;
                                            border-radius: 10px; 
                                            box-shadow: 0px 0px 10px 0px purple;
                                        }

                                    </style>

                                    <div class="table-responsive mt-2">
                                        <table class="table align-middle mb-0 table-striped" id="example2" style="width: 100%;">
                                            <thead class="table-light">
                                                <tr class="bg-light-primary text-primary">
                                                    <th class="text-center ">Id</th>
                                                    <th class="text-center ">Fecha</th>
                                                    <th class=" ">Nombre tercero</th>
                                                    <th class=" ">N° Factura</th>
                                                    <th class="text-center ">Cant.</th>
                                                    <th class="text-center ">Total valor</th>
                                                    <th class="text-center ">Descripcion</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql4 = "SELECT * FROM compra ORDER BY fecha desc, id desc";
                                                $query4 = $conn->query($sql4);
                                                if ($query4->num_rows > 0) {
                                                    while ($row4 = $query4->fetch_assoc()) {
                                                        ?>
                                                <tr class="align-middle" id="hover_enlace" 
                                                            style="cursor: pointer;"

                                                            onclick=" window.location = 'compra-detalle.php?id_compra=<?php echo $row4['id']; ?> ';">

                                                            <td>
                                                                <strong class="text-dark"><?php echo $row4['id']; ?></strong><br>
                                                            </td>
                                                            <td>
                                                                <strong class="text-dark"><?php echo $row4['fecha']; ?></strong><br>
                                                            </td>
                                                            <td class="">
                                                                <?php echo $row4['nombre_tercero']; ?>
                                                            </td>         
                                                            <td class="">
                                                                <?php echo $row4['numero_factura']; ?>
                                                            </td>  
                                                            <td class="text-center">
                                                                <?php
                                                                $sql5 = "SELECT SUM(cantidad) as cantidad FROM compra_detalle WHERE id_compra='" . $row4['id'] . "'";
                                                                $query5 = $conn->query($sql5);
                                                                $row5 = $query5->fetch_assoc();
                                                                ?>

                                                                <?php echo $row5['cantidad']; ?>
                                                            </td>
                                                            <td class="text-end">
                                                                <?php echo number_format($row4['total'], 0); ?>
                                                            </td>                                                    
                                                            <td class="" style="width: 20%;">
                                                                <?php echo $row4['descripcion']; ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->





                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>