<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$id_venta = $_GET['id_venta'];

$sqlpro = "SELECT * FROM alm_venta WHERE id='$id_venta'";
$querypro = $conn->query($sqlpro);
$rowpro = $querypro->fetch_assoc();

$estado = 'Proceso';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="venta.php"> 
                                    Ventas         
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $id_venta; ?></li>
                        </ol>
                    </nav>




                    <div class="card">
                        <div class="card-body">
                            <h4 class="text-center bg-tianzi-claro p-2 "><b>VENTA - <?php echo $rowpro['nombre_tercero']; ?></b></h4>

                            <table class="table table-bordered table-striped table-hover h6" id="">
                                <thead class="">
                                    <tr class="bg-tianzi-claro text-dark">
                                        <th class="">FECHA</th>
                                        <th class="">CONSECUTIVO</th>
                                        <th class="">NUMERO FACTURA</th>
                                        <th class="">OBSERVACION</th>
                                        <th class="text-center">ACCIONES</th>
                                        <th class="text-center">ESTADO</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="text-center">
                                        <td class=""><?php echo $rowpro['fecha']; ?></td>
                                        <td class=""><b><?php echo $rowpro['numero_venta']; ?></b></td>
                                        <td class=""><?php echo $rowpro['numero_factura']; ?></td>
                                        <td class=""><?php echo $rowpro['observacion']; ?></td>
                                        <td> 

                                            <a  href="#editar_venta<?php echo $rowpro['id']; ?>" class="btn btn-warning btn-sm"
                                                data-bs-toggle="modal">
                                                <i class="fas fa-edit  text-white"></i> EDITAR VENTA
                                            </a>

                                            <div class="modal fade text-start" id="editar_venta<?php echo $rowpro['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-sm">
                                                    <div class="modal-content">
                                                        <div class="modal-header bg-warning text-white">
                                                            <h5 class="modal-title card-heading" id="exampleModalLabel">Editar venta</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <form class=" g-3 needs-validation"  method="POST" action="script/venta-editar.php">
                                                            <input class="form-control"  type="text" value="<?php echo $rowusu['nombre']; ?>" name="nombre_usuario" required="" hidden>
                                                            <input class="form-control"  type="text" required="" name="id_venta" value="<?php echo $rowpro['id']; ?>" hidden>
                                                            <div class="modal-body ">
                                                                <div class="col-md-12 mt-2">
                                                                    <label class="form-label" for="validationCustom02">Fecha</label>
                                                                    <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo $rowpro['fecha']; ?>">
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-2">
                                                                    <label class="form-label" for="validationCustom02">Numero factura</label>
                                                                    <input class="form-control" id="validationCustom02" type="text" required="" name="numero_factura" value="<?php echo $rowpro['numero_factura']; ?>">
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-2">
                                                                    <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                                    <select class="form-control" id="validationCustom04" required="" name="nombre_tercero">

                                                                        <option selected=""  value="<?php echo $rowpro['nombre_tercero']; ?>"><?php echo $rowpro['nombre_tercero']; ?></option>
                                                                        <option disabled="" value="">Seleccione</option>
                                                                        <?php
                                                                        $sql6m = "SELECT * FROM alm_tercero";
                                                                        $query6m = $conn->query($sql6m);
                                                                        if ($query6m->num_rows > 0) {
                                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                                ?>

                                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                                <?php
                                                                            }
                                                                        }
                                                                        ?>
                                                                    </select>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                                </div>
                                                                <div class="col-md-12 mt-2 ">
                                                                    <label class="form-label" for="validationCustom02">Observacion</label>
                                                                    <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion"><?php echo $rowpro['observacion']; ?></textarea>
                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                    <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer mt-2">

                                                                <button type="submit" class="btn btn-warning px-2 " name="editar">Guardar cambios</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="">  
                                            <?php
                                            if ($rowpro['estado'] == 'Proceso') {
                                                $color_estado = 'badge alert-info';
                                                $color_estado_2 = '';
                                            } elseif ($rowpro['estado'] == 'Finalizado') {
                                                $color_estado = 'badge alert-success';
                                                $color_estado_2 = '';
                                            }
                                            ?>
                                            <div class="dropdown">
                                                <button class=" btn dropdown-toggle badge <?php echo $color_estado; ?>" style="font-size: 13px; <?php echo $color_estado_2; ?>;" type="button" data-bs-toggle="dropdown" aria-expanded="false"><?php echo $rowpro['estado']; ?></button>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Proceso">
                                                            <i class="fas fa-circle text-info" style="font-size: 13px;"></i> Proceso</a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="script/venta-estado-editar.php?id_venta=<?php echo $id_venta ?>&&estado=Finalizado">
                                                            <i class="fas fa-circle text-success" style="font-size: 13px;"></i> Finalizado</a>
                                                    </li>
                                                </ul>
                                            </div>  
                                        </td>       
                                    </tr>
                                </tbody>

                            </table>
                        </div>
                    </div>



                    <div class="row"> 
                        <div class="col-sm-4">




                            <div class="card">
                                <div class="card-body">


                                    <h6 class="mb-0 text-uppercase">AGREGAR DETALLE A VENTA</h6>
                                    <hr/>
                                    <form class="row g-3 needs-validation" novalidate="" method="POST" action="script/venta-detalle-guardar.php">
                                        <?php
                                        if (isset($_GET['dt_autofocus'])) {
                                            $autofocus_ref = '';
                                            $autofocus_talla = 'autofocus';
                                        } else {
                                            $autofocus_ref = 'autofocus';
                                            $autofocus_talla = '';
                                        }
                                        ?>


                                        <input type="text" name="id_venta" value="<?php echo $id_venta; ?>"  required
                                               class="form-control" hidden>


                                        <div class="col-sm-12">
                                            <label>REFERENCIA:</label>
                                            <select class="form-control  custom-select" name="referencia_producto" required <?php echo $autofocus_ref; ?>>
                                                <?php
                                                if (isset($_GET['dt_referencia'])) {
                                                    ?>
                                                    <option value="<?php echo $_GET['dt_referencia']; ?>"><?php echo $_GET['dt_referencia']; ?></option>

                                                    <?php
                                                } else {
                                                    ?>

                                                    <option value="" disabled="" selected="">seleccione</option>

                                                    <?php
                                                }
                                                ?>
                                                <option disabled></option>
                                                <?php
                                                $sql1 = "SELECT * FROM producto";
                                                $query1 = $conn->query($sql1);
                                                if ($query1->num_rows > 0) {
                                                    while ($row1 = $query1->fetch_assoc()) {
                                                        ?>	 
                                                        <option value="<?php echo $row1['referencia']; ?>"><?php echo $row1['referencia']; ?></option>
                                                        <?php
                                                    }
                                                } else {
                                                    
                                                }
                                                ?>


                                            </select> 
                                        </div>
                                        <div class="col-sm-4">
                                            <label>TALLA</label>
                                            <select class="form-select " id="single-select1" required="" name="talla"  <?php echo $autofocus_talla; ?> >
                                                <?php
                                                for ($i = 10; $i < 50; $i++) {
                                                    ?>
                                                    <option value="<?php echo $i ?>">Talla <?php echo $i ?></option>
                                                    <?php
                                                }
                                                ?>
                                            </select>
                                        </div>


                                        <div class="col-sm-4">
                                            <label>CANTIDAD</label>
                                            <input type="text" name="cantidad" id="cantidad" oninput="calcularTotal()"  required
                                                   class="form-control">
                                        </div>
                                        <div class="col-sm-4">
                                            <label>PRECIO UNIDAD</label>
                                            <?php
                                            if (isset($_GET['dt_precio_unidad'])) {
                                                $precio_unidad = $_GET['dt_precio_unidad'];
                                            } else {
                                                $precio_unidad = 0;
                                            }
                                            ?>
                                            <input type="text" name="precio_unidad" id="precio_unidad"  oninput="calcularTotal()" required value="<?php echo $precio_unidad; ?>"
                                                   class="form-control">
                                        </div>

                                        <div class="col-sm-12">
                                            <label>TOTAL</label>
                                            <input type="text" class="form-control" name="total" id="total" value="0" required readonly="">
                                        </div>
                                        <div class="col-md-12 text-end">
                                            <button type="submit" class="btn btn-success" >Guardar</button>

                                        </div>
                                    </form>

                                    <script>


                                        function calcularTotal() {
                                            var precio_unidad = parseFloat(document.getElementById("precio_unidad").value);
                                            var cantidad = parseInt(document.getElementById("cantidad").value);


                                            var total = cantidad * precio_unidad;
                                            document.getElementById("total").value = total;
                                        }
                                    </script>


                                </div>
                            </div>
                        </div>


                        <div class="col-sm-8">




                            <div class="card">
                                <div class="card-body">
                                    <form action="script/importar.php" method="post" name="frmExcelImport" id="frmExcelImport" enctype="multipart/form-data">
                                        <input class="" type="text" name="id_venta" value="<?php echo $id_venta; ?>" hidden="">
                                        <div>
                                            <label>Elija Archivo Excel</label> 
                                            <input class="dropify" type="file" name="file"id="file" accept=".xls,.xlsx">

                                            <button type="submit" id="submit" name="import" class="btn btn-success float-end mt-3"><i class="fas fa-file-excel"></i> Importar detalle de venta</button>

                                        </div>

                                    </form>

                                    <script>

                                        $('.dropify').dropify();


                                    </script>

                                </div>
                            </div>
                        </div>


                        <div class="card">
                            <div class="card-body">

                                <div class="row">
                                    <div class="col-sm-6">
                                        <h6 class="mb-0 text-uppercase">DETALLE DE VENTA</h6>
                                    </div>
                                    <div class="col-sm-6 text-end">
                                        <form method="post" action="script/venta-detalle-eliminar.php" >
                                            <input type="text" name="id_venta" value="<?php echo $id_venta; ?>" hidden="">
                                            <button type="submit" class="btn btn-danger confirmacion-clic"><i class="fas fa-trash-alt"></i> Eliminar datos</button>
                                        </form>
                                    </div>
                                </div>

                                <hr/>
                                <div class="table-responsive mt-2">
                                    <table class="table table-bordered table-striped table-hover" id="">
                                        <thead class="">
                                            <tr class="bg-success text-dark text-center"> 
                                                <th class=" " style="width: 5%;" >FOTO</th>

                                                <th class="text-start" >REFERENCIA</th>
                                                <?php
                                                $item = 0;
                                                $sqlt1 = "SELECT * FROM alm_venta_detalle WHERE id_venta='$id_venta' GROUP BY talla ORDER BY talla asc";
                                                $queryt1 = $conn->query($sqlt1);
                                                if ($queryt1->num_rows > 0) {
                                                    while ($rowt1 = $queryt1->fetch_assoc()) {
                                                        ?>
                                                        <th class="text-center p-1"><?php echo $rowt1['talla']; ?></th>
                                                        <?php
                                                        $item++;
                                                    }
                                                }
                                                ?>

                                                <th class="text-center p-1" style="width: 3%;">T. PARES</th>
                                                <th class="text-center p-1" style="width: 7%;">VR. UNIT</th>
                                                <th class="text-center p-1" style="width: 12%;">VR. TOTAL</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_cantidad = 0;
                                            $total_venta = 0;

                                            $sql3 = "SELECT * FROM alm_venta_detalle WHERE id_venta='$id_venta' GROUP BY referencia_producto, precio_unidad";
                                            $query3 = $conn->query($sql3);

                                            if ($query3->num_rows > 0) {
                                                while ($row3 = $query3->fetch_assoc()) {

                                                    $sql2 = "SELECT * FROM producto WHERE referencia='" . $row3['referencia_producto'] . "'";
                                                    $query2 = $conn->query($sql2);
                                                    $row2 = $query2->fetch_assoc();

                                                    ////CANTIDAD POR REFERENCIA
                                                    $sqlCANT = "SELECT SUM(cantidad) as cantidad_referencia FROM alm_venta_detalle WHERE id_venta='$id_venta' AND referencia_producto='" . $row3['referencia_producto'] . "'  AND precio_unidad='" . $row3['precio_unidad'] . "'";
                                                    $queryCANT = $conn->query($sqlCANT);
                                                    $rowCANT = $queryCANT->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                        <td class="text-center"> 
                                                            <?php
                                                            if ($row2['foto1'] == 'NO APLICA') {
                                                                ?>
                                                                <img class="img-thumbnail" src="../../img/camara.jpg" width="40" alt="alt"/>
                                                                <?php
                                                            } else {
                                                                ?>
                                                                <img class="" src="../../img-producto/<?php echo $row2['foto1']; ?>" width="40" height="40" alt="alt"/>
                                                                <?php
                                                            }
                                                            ?>
                                                        </td>
                                                        <td> 
                                                            <strong ><?php echo $row2['referencia']; ?></strong>
                                                        </td>

                                                        <?php
                                                        $queryt2 = $conn->query($sqlt1);
                                                        if ($queryt2->num_rows > 0) {
                                                            while ($rowt2 = $queryt2->fetch_assoc()) {

                                                                $sqlt4 = "SELECT SUM(cantidad) as suma_talla FROM alm_venta_detalle WHERE id_venta='$id_venta' AND referencia_producto='" . $row3['referencia_producto'] . "' AND talla='" . $rowt2['talla'] . "' AND precio_unidad='" . $row3['precio_unidad'] . "'";
                                                                $queryt4 = $conn->query($sqlt4);
                                                                $rowt4 = $queryt4->fetch_assoc();

                                                                $suma_talla = $rowt4['suma_talla'];
                                                                ?>
                                                                 <td class="ancho text-center">                                                                      
                                                                        <a href="#!" data-bs-toggle="modal" data-bs-target="#eliminar_talla" class=""
                                                                           data-referencia_producto="<?php echo $row3['referencia_producto']; ?>"
                                                                           data-talla="<?php echo $rowt2['talla']; ?>"
                                                                           data-precio_unidad="<?php echo $rowt2['precio_unidad']; ?>"
                                                                           
                                                                           data-cantidad="<?php echo $suma_talla; ?>"

                                                                           style="color: black; text-decoration: none;">

                                                                            <div id="hover_enlace" >
                                                                                <?php echo $suma_talla; ?>
                                                                            </div>

                                                                        </a>
                                                                    </td>
                                                                <?php
                                                            }
                                                        }
                                                        ?>

                                                        <td class="text-center"><b><?php echo $rowCANT['cantidad_referencia']; ?></b></td>  
                                                        <td class="" style="text-align: right;">

                                                            <a class="" href="#!" data-bs-toggle="modal" data-bs-target="#editar_precio"
                                                               data-id_venta="<?php echo $id_venta; ?>"
                                                               data-referencia_producto="<?php echo $row3['referencia_producto']; ?>"
                                                               data-precio_unidad="<?php echo $row3['precio_unidad']; ?>">

                                                                <div id="hover_enlace"  class="h6">
                                                                    $ <?php echo number_format($row3['precio_unidad'], 0, '.', ','); ?>
                                                                </div>
                                                            </a>

                                                        </td> 



                                                        <td class="" style="text-align: right; ">
                                                            <b class="float-start">$</b> 
                                                            <b class="h6"><?php echo number_format($rowCANT['cantidad_referencia'] * $row3['precio_unidad'], 0, '.', ','); ?></b>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                    $total_venta += $rowCANT['cantidad_referencia'] * $row3['precio_unidad'];
                                                    $total_cantidad += $rowCANT['cantidad_referencia'];
                                                }
                                            }
                                            ?>
                                            <tr class="h5 bg-light-dark">
                                                <td class="text-end" colspan="<?php echo $item + 2; ?>"><b>TOTAL</b></td>
                                                <td class="text-center"><b><?php echo $total_cantidad; ?></b></td>
                                                <td></td>
                                                <td class="text-end">
                                                    <b class="float-start">$</b> 
                                                    <b><?php echo number_format($total_venta, 0); ?></b>
                                                </td>
                                            </tr>
                                        </tbody>

                                    </table>
                                </div>



                            </div>
                        </div>

                    </div>
                </div>



                <?php
                $sql1 = "UPDATE alm_venta SET total_venta='$total_venta' WHERE id='$id_venta'";
                if ($conn->query($sql1) === TRUE) {
                    
                } else {
                    echo "Error: " . $sql1 . "<br>" . $conn->error;
                }
                ?>



                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
    </div>
    <!--end wrapper-->
    <?php echo include '../general/libreria-js.php'; ?>

    
    <div class="modal fade" id="eliminar_talla" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h5 class="modal-title card-heading " id="exampleModalLabel"><b class="text-white">Eliminar talla</b></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/venta-talla-eliminar.php">
                    <input class="form-control" type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>"  readonly="">
                    <input class="form-control" type="text" required="" name="id_venta" value="<?php echo $id_venta; ?>" hidden="" readonly="">

                    <input class="form-control" type="text" required="" name="numero_venta" value="<?php echo $row['numero_venta']; ?>" hidden="" readonly="">


                    <div class="modal-body row">
                        <div class="col-md-12">
                            <label class="form-label" for="validationCustom01">¿Estas seguro que deseas eliminar la siguiente registro?</label>

                        </div>
                        <div class="col-md-12 mb-2">
                            <label>Referencia:</label>
                            <input class="form-control" type="text" required="" name="referencia_producto" id="t_referencia_producto"  readonly="">

                        </div>
                        


                        <div class="col-md-4">
                            <label>Talla:</label>

                            <input class="form-control" type="text" required="" name="talla" id="t_talla"  readonly="">

                        </div>
                        <div class="col-md-4">
                            <label>Cantidad:</label>

                            <input class="form-control" type="text" required="" name="cantidad" id="t_cantidad"  readonly="">

                        </div>
                        <div class="col-md-4">
                            <label>Costo unidad:</label>

                    <input class="form-control" type="text" required="" name="precio_unidad" id="t_precio_unidad" readonly="">

                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger confirmacion-clic" >Eliminar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // PASO DE PARAMETROS EDITAR
        $('#eliminar_talla').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal

            var referencia_producto = button.data('referencia_producto')
            var talla = button.data('talla')
            var cantidad = button.data('cantidad')
            var precio_unidad = button.data('precio_unidad')


            $('#t_referencia_producto').val(referencia_producto)
            $('#t_talla').val(talla)
            $('#t_cantidad').val(cantidad)
            $('#t_precio_unidad').val(precio_unidad)
        });

    </script>


    
    
    <script>



        //Tabla producto
        $(document).ready(function () {
            var select1 = $('#single-select1').select2({
                theme: 'bootstrap4',
                width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
                placeholder: $(this).data('placeholder'),
                allowClear: Boolean($(this).data('allow-clear')),
            });


        });

        //Tabla producto
        $(document).ready(function () {
            var table = $('#example2').DataTable({
                lengthChange: false,
                buttons: ['copy', 'excel', 'pdf', 'print'],
                "order": false,
            });

            table.buttons().container()
                    .appendTo('#example2_wrapper .col-md-6:eq(0)');
        });

    </script>



    <div class="modal fade" id="editar_precio" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title card-heading" id="exampleModalLabel">Formulario | Editar precio</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/venta-precio-editar.php">
                    <input class="form-control" type="text" required="" name="edit_id_venta" id="edit_id_venta" hidden="">

                    <div class="modal-body ">
                        <div class="row ">
                            <div class="col-md-6">
                                <label class="form-label" for="validationCustom01">Referencia:</label>
                                <input class="form-control" type="text" required="" name="edit_referencia_producto" id="edit_referencia_producto" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite la referencia.</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="validationCustom01">Precio actual:</label>
                                <input class="form-control" type="text" required="" name="edit_precio_unidad" id="edit_precio_unidad" readonly>
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite precio actual.</div>
                            </div>
                            <div class="col-md-12 mt-3">
                                <label class="form-label" for="validationCustom01">precio unitario:</label>
                                <input class="form-control" type="text" required="" name="edit_precio_unidad_nuevo" id="precio_unitario_nuevo">
                                <div class="valid-feedback">Se ve bien!</div>
                                <div class="invalid-feedback">Por favor, Digite el precio nuevo.</div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary px-5 radius-30" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary px-5 radius-30" >Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        // PASO DE PARAMETROS EDITAR
        $('#editar_precio').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal

            var id_venta = button.data('id_venta')
            var referencia_producto = button.data('referencia_producto')
            var precio_unidad = button.data('precio_unidad')


            $('#edit_id_venta').val(id_venta)
            $('#edit_referencia_producto').val(referencia_producto)
            $('#edit_precio_unidad').val(precio_unidad)
        });

    </script>

</body>
</html>