<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Usuarios</li>
                        </ol>
                    </nav>








                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">NUEVO USUARIO</h6>
                                    <hr/>

                                    <form class=" g-3 needs-validation" method="POST" action="script/usuario-guardar.php">


                                        <div class="row ">
                                            <div class="col-md-12">
                                                <h6 class=""><b>Información del usuario:</b></h6>

                                                <div class="row ">
                                                    <div class="col-md-4 mb-3">
                                                        <label class="form-label" for="validationCustom01">Cedula</label>
                                                        <input class="form-control" id="validationCustom01" type="text" required="" name="cedula" autofocus="">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, introduzca un numero de cedula.</div>
                                                    </div>
                                                    <div class="col-md-8 mb-3">
                                                        <label class="form-label" for="validationCustom02">Primer nombre y apellido</label>
                                                        <input class="form-control" id="validationCustom02" type="text" required="" name="nombre">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, introduzca un nombre de pila.</div>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                        <label class="form-label" for="validationCustomUsername">Correo</label>
                                                        <div class="input-group has-validation"><span class="input-group-text" id="inputGroupPrepend">@</span>
                                                            <input class="form-control" id="validationCustomUsername" type="text" aria-describedby="inputGroupPrepend" required="" name="correo" value="No aplica">
                                                            <div class="valid-feedback">Se ve bien!</div>
                                                            <div class="invalid-feedback">Por favor, introduzca un correo electronico.</div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                        <label class="form-label" for="validationCustom02">Telefono</label>
                                                        <input class="form-control" id="validationCustom02" type="text" required="" name="telefono" value="No aplica">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, introduzca un numero de telefono.</div>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class=" col-12 col-sm-12">
                                                <h6 class=""><b>Datos de acceso:</b></h6>

                                                <div class="row">
                                                    <div class="col-md-4 mb-3">
                                                        <label class="form-label" for="validationCustom02">Usuario</label>
                                                        <input class="form-control" id="validationCustom02" type="text"  required="" name="usuario">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, introduzca su nombre de usuario.</div>
                                                    </div>
                                                    <div class="col-md-4 mb-3">
                                                        <label class="form-label" for="validationCustom03">Clave</label>
                                                        <input class="form-control" id="validationCustom03" type="text" required="" name="clave">
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, introduzca un clave.</div>
                                                    </div>
                                                    <div class="col-md-4 mb-3">
                                                        <label class="form-label" for="validationCustom04">Rol</label>
                                                        <select class="form-select" id="validationCustom04" required="" name="rol">
                                                            <option selected="" disabled="" value="">Seleccione</option>
                                                            <option value="Administrador">Administrador</option>
                                                            <option value="Asesor">Asesor</option>
                                                            <option value="Bodega">Bodega</option>
                                                            <option value="Seguimiento">Seguimiento</option>
                                                        </select>
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="col-12 col-sm-12">
                                                <h6 class=""><b>Configuracion:</b></h6>

                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="form-label" for="validationCustom04">Estado</label>
                                                        <select class="form-select" id="validationCustom04" required="" name="estado">
                                                            <option disabled="" value="">Seleccione</option>
                                                            <option selected="" value="Activo">Activo</option>
                                                            <option value="Inactivo">Inactivo</option>
                                                        </select>
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="form-label" for="validationCustom04">Mostrar</label>
                                                        <select class="form-select" id="validationCustom04" required="" name="mostrar">
                                                            <option disabled="" value="">Seleccione</option>
                                                            <option selected="" value="Si">Si</option>
                                                            <option value="No">No</option>
                                                        </select>
                                                        <div class="valid-feedback">Se ve bien!</div>
                                                        <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>



                                        <hr>
                                        <div class="row mt-2">
                                            <div class="col-md-12 text-end">
                                                <button type="submit" class="btn btn-success px-5 radius-30" >Guardar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-8">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">LISTA DE USUARIOS</h6>
                                    <hr/>
                                    <div class="table-responsive mt-2">
                                        <table class="table table-bordered table-striped table-hover" id="example2">
                                            <thead class="">
                                                <tr class="bg-tianzi text-dark">
                                                    <th >CEDULA</th>
                                                    <th >NOMBRE</th>
                                                    <th class="">CONTACTO</th>
                                                    <th class="">USUARIO</th>
                                                    <th class="">ESTADO</th>
                                                    <th class="">MOSTRAR</th>
                                                    <th class="text-center">ACCIONES</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql = "SELECT * FROM alm_usuario";
                                                $query = $conn->query($sql);
                                                if ($query->num_rows > 0) {
                                                    while ($row = $query->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle">
                                                            <td>
                                                                <?php echo $row['cedula']; ?>

                                                            </td>
                                                            <td>
                                                                <b><?php echo $row['nombre']; ?></b><br>
                                                                <b class="text-bronze"><?php echo $row['rol']; ?></b>
                                                            </td>
                                                            <td class="">
                                                                <?php echo $row['correo']; ?><br>
                                                                <?php echo $row['telefono']; ?>
                                                            </td>
                                                            <td class="">
                                                                <b class="text-secondary"><?php echo $row['usuario']; ?></b><br>
                                                                <span>**********</span>
                                                            </td>
                                                        
                                                            <td class="text-center">
                                                                <?php
                                                                if ($row['estado'] == 'Activo') {
                                                                    ?>
                                                                    <span class="badge alert-success"><?php echo $row['estado']; ?></span>

                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <span class="badge alert-danger"><?php echo $row['estado']; ?></span>

                                                                    <?php
                                                                }
                                                                ?>


                                                            </td>
                                                            <td class="text-center">
                                                                <?php
                                                                if ($row['mostrar'] == 'Si') {
                                                                    ?>
                                                                    <span class="badge alert-success"><?php echo $row['mostrar']; ?></span>

                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <span class="badge alert-danger"><?php echo $row['mostrar']; ?></span>

                                                                    <?php
                                                                }
                                                                ?>


                                                            </td>

                                                            <td class="text-center">
                                                                <a  href="#editar"
                                                                    data-bs-toggle="modal"
                                                                    data-bs-target="#editar<?php echo $row['id']; ?>">
                                                                    <i class="far fa-edit text-warning"></i>
                                                                </a>

                                                                <div class="modal fade text-start" id="editar<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-xl">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header bg-warning text-white">
                                                                                <h5 class="modal-title card-heading" id="exampleModalLabel">EDITAR TERCERO</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class="" method="POST" action="script/usuario-editar.php">
                                                                                <input class="form-control" type="text" required="" name="id" value="<?php echo $row['id']; ?>" hidden="">

                                                                                <div class="modal-body ">

                                                                                    <div class="row ">
                                                                                        <div class="col-md-6">
                                                                                            <h6 class=""><b>Información del usuario:</b></h6>

                                                                                            <div class="row ">
                                                                                                <div class="col-md-4 mb-3">
                                                                                                    <label class="form-label" for="validationCustom01">Cedula</label>
                                                                                                    <input class="form-control" id="validationCustom01" type="text" required="" name="cedula" value="<?php echo $row['cedula']; ?>" autofocus="">
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, introduzca un numero de cedula.</div>
                                                                                                </div>
                                                                                                <div class="col-md-8 mb-3">
                                                                                                    <label class="form-label" for="validationCustom02">Primer nombre y apellido</label>
                                                                                                    <input class="form-control" id="validationCustom02" type="text" required="" name="nombre" value="<?php echo $row['nombre']; ?>">
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, introduzca un nombre de pila.</div>
                                                                                                </div>
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustomUsername">Correo</label>
                                                                                                    <div class="input-group has-validation"><span class="input-group-text" id="inputGroupPrepend">@</span>
                                                                                                        <input class="form-control" id="validationCustomUsername" type="text" aria-describedby="inputGroupPrepend" required="" name="correo" value="<?php echo $row['correo']; ?>">
                                                                                                        <div class="valid-feedback">Se ve bien!</div>
                                                                                                        <div class="invalid-feedback">Por favor, introduzca un correo electronico.</div>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustom02">Telefono</label>
                                                                                                    <input class="form-control" id="validationCustom02" type="text" required="" name="telefono" value="<?php echo $row['telefono']; ?>">
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, introduzca un numero de telefono.</div>
                                                                                                </div>
                                                                                            </div>

                                                                                        </div>
                                                                                        <div class=" col-12 col-sm-3">
                                                                                            <h6 class=""><b>Datos de acceso:</b></h6>

                                                                                            <div class="row">
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustom02">Usuario</label>
                                                                                                    <input class="form-control" id="validationCustom02" type="text"  required="" name="usuario" value="<?php echo $row['usuario']; ?>">
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, introduzca su nombre de usuario.</div>
                                                                                                </div>
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustom03">Clave</label>
                                                                                                    <input class="form-control" id="validationCustom03" type="text" required="" name="clave" value="<?php echo $row['clave']; ?>">
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, introduzca un clave.</div>
                                                                                                </div>
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustom04">Rol</label>
                                                                                                    <select class="form-select" id="validationCustom04" required="" name="rol">
                                                                                                        <option selected="" value="<?php echo $row['rol']; ?>"><?php echo $row['rol']; ?></option>
                                                                                                        <option disabled="" value="">Seleccione</option>
                                                                                                        <option value="Administrador">Administrador</option>
                                                                                                        <option value="Asesor">Asesor</option>
                                                                                                        <option value="Bodega">Bodega</option>
                                                                                                        <option value="Seguimiento">Seguimiento</option>
                                                                                                    </select>
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                                                                                </div>
                                                                                            </div>

                                                                                        </div>
                                                                                        <div class="col-12 col-sm-3">
                                                                                            <h6 class=""><b>Configuracion:</b></h6>

                                                                                            <div class="row">
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustom04">Estado</label>
                                                                                                    <select class="form-select" id="validationCustom04" required="" name="estado">
                                                                                                        <option selected="" value="<?php echo $row['estado']; ?>"><?php echo $row['estado']; ?></option>
                                                                                                        <option disabled="" value="">Seleccione</option>
                                                                                                        <option value="Activo">Activo</option>
                                                                                                        <option value="Inactivo">Inactivo</option>
                                                                                                    </select>
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                                                                                </div>
                                                                                                <div class="col-md-12 mb-3">
                                                                                                    <label class="form-label" for="validationCustom04">Mostrar</label>
                                                                                                    <select class="form-select" id="validationCustom04" required="" name="mostrar">
                                                                                                        <option selected="" value="<?php echo $row['mostrar']; ?>"><?php echo $row['mostrar']; ?></option>
                                                                                                        <option disabled="" value="">Seleccione</option>
                                                                                                        <option value="Si">Si</option>
                                                                                                        <option value="No">No</option>
                                                                                                    </select>
                                                                                                    <div class="valid-feedback">Se ve bien!</div>
                                                                                                    <div class="invalid-feedback">Por favor, seleccione el rol para el usuario.</div>
                                                                                                </div>
                                                 
                                                                                            </div>

                                                                                        </div>
                                                                                    </div>

                                                                                </div>
                                                                                <div class="modal-footer">
                                                                                    <button type="submit" class="btn btn-warning  radius-30" name="editar" >Guardar cambios</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>




                                                                <a href="#" class="ms-4" 
                                                                   data-bs-toggle="modal" data-bs-target="#eliminar<?php echo $row['id']; ?>">
                                                                    <i class="far fa-trash-alt opacity-5 text-danger"></i>
                                                                </a>

                                                                <div class="modal fade" id="eliminar<?php echo $row['id']; ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-sm">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header bg-danger">
                                                                                <h5 class="modal-title card-heading text-white" id="exampleModalLabel">Eliminar</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <form class=" g-3 needs-validation" novalidate="" method="POST" action="script/usuario-eliminar.php">
                                                                                <input class="form-control" type="text" required="" name="id" value="<?php echo $row['id']; ?>" hidden>
                                                                                <div class="modal-body ">
                                                                                    ¿Seguro deseas eliminar este registro?

                                                                                </div>
                                                                                <div class="modal-footer ">
                                                                                    <button type="submit" class="btn btn-danger" name="eliminar" >Eliminar</button>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>




                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['excel', 'pdf'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>