<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
} else {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">

                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">Reporte de vendedores</li>
                        </ol>


                    </nav>


                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-2 border rounded">

                                        <form method="GET" action="rpt-vendedores-fecha.php" class=" d-print-none">
                                            <div class="row">
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Desde</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                    </div>
                                                </div>
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Hasta</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                    </div>
                                                </div>
                                                <div class="col-5 col-sm-1 pt-3">
                                                    <div class="form-group">
                                                        <button class="btn btn-tianzi px-2 radius-10" type="submit" name="filtro" style="width: 100%;">
                                                            Consultar
                                                        </button>  
                                                    </div>
                                                </div>
                                            </div>
                                        </form>

                                        <?php
                                        if (isset($_GET['filtro'])) {

                                            $fecha_desde = $_GET['fecha_desde'];
                                            $fecha_hasta = $_GET['fecha_hasta'];

                                            $sql = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                            $sql1 = "v.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                        } else {
                                            $fecha_desde = $_GET['fecha_desde'];
                                            $fecha_hasta = $_GET['fecha_hasta'];

                                            $sql = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                            $sql1 = "v.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">


                                </div>
                                <div class="col-sm-4">
                                    <h6 class=" mb-3 text-center"><b>Ventas <br><?php echo strftime("%d - %B - %Y", strtotime(date($fecha_desde))); ?> <strong class="text-info">al</strong> <?php echo strftime("%d - %B - %Y", strtotime(date($fecha_hasta))); ?></b></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->
                    <style>
                        #hover_enlace:hover{
                            color: orange;
                            border-radius: 10px; border: #3fc3ee 1px solid;
                            box-shadow: 0px 0px 5px 0px #3fc3ee;
                        }

                    </style>


                    <div class="row">
                        <div class="col-sm-5">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                                    <?php
                                    $fecha1 = new DateTime($fecha_desde);
                                    $fecha2 = new DateTime($fecha_hasta);
                                    $diff = $fecha1->diff($fecha2);

                                    $dias = $diff->days + 1;
                                    ?>
                                    <span>Ventas de <strong><?php echo $dias; ?></strong> dias</span><br> Obligacion diaria <?php echo number_format($meta, 0); ?><br>
                                    <strong class="text-secondary"><?php echo number_format($total_meta = $dias * $meta, 0); ?></strong>  <i class="fas fa-flag-checkered"></i>

                                    <hr>

                                    <?php
                                    $total_monto = 0;
                                    $total_ordenes = 0;
                                    $total_prendas = 0;
                                    $sql7 = "SELECT nombre_usuario FROM venta WHERE $sql GROUP BY nombre_usuario";
                                    $query7 = $conn->query($sql7);
                                    if ($query7->num_rows > 0) {
                                        while ($row7 = $query7->fetch_assoc()) {


                                            $sql8 = "SELECT SUM(total_venta) as total_venta FROM venta WHERE nombre_usuario='" . $row7['nombre_usuario'] . "'  AND  $sql AND "
                                                    . "estado NOT IN ('Proceso', 'Devolucion', 'Cancelado')";
                                            $query8 = $conn->query($sql8);
                                            $row8 = $query8->fetch_assoc();

                                            $sql9 = "SELECT COUNT(id) as contar_venta FROM venta WHERE  nombre_usuario='" . $row7['nombre_usuario'] . "'  AND  $sql AND "
                                                    . "estado NOT IN ('Proceso', 'Devolucion', 'Cancelado')";
                                            $query9 = $conn->query($sql9);
                                            $row9 = $query9->fetch_assoc();

                                            $sql10 = "SELECT SUM(vd.cantidad) as cantidad_prendas
                                                    FROM venta v, venta_detalle vd
                                                    WHERE v.id=vd.id_venta AND v.nombre_usuario='" . $row7['nombre_usuario'] . "'  AND  $sql1 AND vd.estado NOT IN ('Proceso', 'Devolucion', 'Cancelado')";
                                            $query10 = $conn->query($sql10);
                                            $row10 = $query10->fetch_assoc();

                                            if ($row8['total_venta'] <= 0) {
                                                $porcentaje1 = 0;
                                            } else {
                                                $porcentaje1 = 100 / ($meta / $row8['total_venta']);
                                            }

                                            if ($porcentaje1 < 100) {
                                                $porcentaje_texto = 'Incompleto';
                                            } else {
                                                $porcentaje_texto = 'Completo';
                                            }

                                            if ($porcentaje1 <= 20) {
                                                $porcentaje_color = 'bg-danger';
                                            } elseif ($porcentaje1 > 20 AND $porcentaje1 <= 79) {
                                                $porcentaje_color = 'bg-warning';
                                            } elseif ($porcentaje1 >= 80 AND $porcentaje1 <= 99) {
                                                $porcentaje_color = 'bg-info';
                                            } elseif ($porcentaje1 > 100) {
                                                $porcentaje_color = 'bg-success';
                                            }
                                            ?>
                                            <div class="p-2" id="hover_enlace">
                                                <a href="rpt-vendedor.php?nombre_usuario=<?php echo $row7['nombre_usuario']; ?>&&fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>" >

                                                    <div class="card radius-10 shadow-none mb-0 text-dark">
                                                        <div class="d-flex align-items-center gap-3">

                                                            <h6 class="mb-0"><strong><?php echo $row7['nombre_usuario']; ?></strong></h6>
                                                            <div class="ms-auto"><strong><?php echo number_format($row8['total_venta']); ?></strong></div>
                                                        </div>
                                                        <span class="text-secondary " style="font-size: 12px;"><?php echo $row9['contar_venta']; ?> Ordenes | <?php echo number_format($row10['cantidad_prendas'], 0, '.', ','); ?> Pares</span>
                                                        <div class="progress" style="height:7px;">
                                                            <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="<?php echo $porcentaje1; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $porcentaje1; ?>%"></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                            <hr>
                                            <?php
                                            $total_monto += $row8['total_venta'];
                                            $total_ordenes += $row9['contar_venta'];
                                            $total_prendas += $row10['cantidad_prendas'];
                                        }
                                    }
                                    ?>


                                </div>
                            </div>
                        </div>

                        <div class="col-xl-7 d-flex">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                                    <h6><b>Ventas</b></h6>
                                    <div class="row">
                                        <?php
                                        $estados = array("Proceso", "Confirmado", "Alistamiento", "Enviado", "Novedad", "Entregado", "Cancelado", "Devolucion");

                                        $total_ordenes = 0;
                                        $total_prendas = 0;
                                        $total_monto = 0;
                                        for ($i = 0; $i < 8; $i++) {
                                            $estados[$i];

                                            if ($estados[$i] == 'Proceso') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-info';
                                            } elseif ($estados[$i] == 'Confirmado') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-pink';
                                            } elseif ($estados[$i] == 'Alistamiento') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-primary';
                                            } elseif ($estados[$i] == 'Enviado') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-warning';
                                            } elseif ($estados[$i] == 'Novedad') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-bronze';
                                            } elseif ($estados[$i] == 'Entregado') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-success';
                                            } elseif ($estados[$i] == 'Cancelado') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-secondary';
                                            } elseif ($estados[$i] == 'Devolucion') {
                                                $alert_text = 'text-white';
                                                $alert = 'bg-dark';
                                            } else {
                                                $text = 'text-dark';
                                            }

                                            $sqlv1 = "SELECT SUM(total_venta) AS total_venta_proceso, COUNT(id) as contar_ventas FROM venta WHERE estado='" . $estados[$i] . "' AND  $sql";
                                            $queryv1 = $conn->query($sqlv1);
                                            $rowv1 = $queryv1->fetch_assoc();

                                            $sqlv1c = "SELECT SUM(vd.cantidad) as cantidad_prendas
                                                            FROM venta v, venta_detalle vd
                                                            WHERE v.id=vd.id_venta AND  vd.estado='" . $estados[$i] . "' AND  $sql1";
                                            $queryv1c = $conn->query($sqlv1c);
                                            $rowv1c = $queryv1c->fetch_assoc();
                                            ?>


                                            <style>
                                                #panel_estado:hover{
                                                    border-radius: 10px; border: gray 2px solid;
                                                }

                                            </style>


                                            <div class="col-sm-4 mt-3">
                                                <a href="rpt-lista-venta-general.php?estado=<?php echo $estados[$i]; ?>&&fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta ?>">
                                                    <div class="card radius-10 shadow-none mb-0 <?php echo $alert; ?>" id="panel_estado">
                                                        <div class="card-body <?php echo $alert_text; ?> p-3">
                                                            <div class="d-flex align-items-center gap-3">
                                                                <h6 class="mb-0"><b><?php echo $estados[$i]; ?></b></h6>
                                                                <div class="ms-auto"><b><?php echo number_format($rowv1['total_venta_proceso'], 0); ?></b></div>
                                                            </div>
                                                            <span><?php echo $rowv1['contar_ventas']; ?> | <?php echo number_format($rowv1c['cantidad_prendas'], 0, '.', ','); ?> Pares</span>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <?php
                                            $total_ordenes += $rowv1['contar_ventas'];
                                            $total_prendas += $rowv1c['cantidad_prendas'];
                                            $total_monto += $rowv1['total_venta_proceso'];
                                        }
                                        ?>

                                        <style>
                                            #total{
                                                border-radius: 10px; border: gray 1px solid;
                                                box-shadow: 0px 0px 5px 0px gray;
                                            }

                                        </style>

                                        <div class="col-sm-4 mt-3">
                                            <div class="card radius-10 shadow-none mb-0 bg-light" id="total">
                                                <div class="card-body p-3">
                                                    <div class="d-flex align-items-center gap-3">
                                                        <h6 class="mb-0">Total</h6>

                                                        <div class="ms-auto"><b><?php echo number_format($total_monto, 0); ?></b></div>
                                                    </div>
                                                    <span><?php echo $total_ordenes; ?> | <?php echo number_format($total_prendas, 0, '.', ','); ?> Prendas</span>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr>

                                    <div class="table-responsive mt-2 ">
                                        <table class="table mb-0 font-11 table-striped table-bordered table-hover " id="example1"  style="color: black; font-size: 12px;">
                                            <thead>
                                                <tr class="bg-tianzi text-dark">
                                                    <th class="text-center">ID</th>
                                                    <th class="">CLIENTE</th>
                                                    <th class="text-center">TOTAL</th>
                                                    <th class="text-center">ESTADO</th>
                                                    <th class="text-center">ASESOR</th>
                                                    <th class="text-center">DETALLE</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $item = 0;
                                                $total_monto_prendas = 0;
                                                $total_comision = 0;
                                                $total_monto_prendas_con = 0;
                                                $total_comision_con = 0;

                                                $total_flete_con = 0;
                                                $total_venta_con = 0;
                                                $sqlh = "SELECT * FROM venta WHERE $sql";
                                                $queryh = $conn->query($sqlh);
                                                if ($queryh->num_rows > 0) {
                                                    while ($rowh = $queryh->fetch_assoc()) {

                                                        if ($rowh['estado'] == 'Proceso' || $rowh['estado'] == 'Cancelado') {
                                                            $total_venta = 0;
                                                        } else {
                                                            $total_venta = $rowh['total_venta'];
                                                        }
                                                        ?>
                                                        <tr> 
                                                            <td class="text-center">
                                                                <b><?php echo $rowh['id']; ?></b>
                                                            </td>
                                                            <td class="">
                                                                <b>
                                                                    <?php echo $rowh['nombre']; ?>
                                                                </b>
                                                            </td>
                                                            <td class="text-end"  >
                                                                <?php echo number_format($total_venta, 0, ',', '.'); ?>
                                                            </td> 
                                                            <td class="text-center align-middle">
                                                                <style>
                                                                    .badge-orange{
                                                                        background-color: orange;
                                                                    }

                                                                    .badge-yellow{
                                                                        background-color: yellow;
                                                                    }
                                                                </style>
                                                                <?php
                                                                if ($rowh['estado'] == 'Proceso') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-info';
                                                                } elseif ($rowh['estado'] == 'Confirmado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-pink';
                                                                } elseif ($rowh['estado'] == 'Alistamiento') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-primary';
                                                                } elseif ($rowh['estado'] == 'Enviado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-warning';
                                                                } elseif ($rowh['estado'] == 'Novedad') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-bronze';
                                                                } elseif ($rowh['estado'] == 'Entregado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-success';
                                                                } elseif ($rowh['estado'] == 'Cancelado') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-secondary';
                                                                } elseif ($rowh['estado'] == 'Devolucion') {
                                                                    $alert_text = 'text-white';
                                                                    $alert = 'bg-dark';
                                                                } else {
                                                                    $text = 'text-dark';
                                                                }
                                                                ?>
                                                                <span class="badge <?php echo $alert; ?>"><?php echo $rowh['estado']; ?></span>
                                                            </td>
                                                            <td class="">
                                                                <b class="text-secondary"><?php echo $rowh['nombre_usuario']; ?></b>
                                                            </td>
                                                            <td class="text-center">

                                                                <a class="p-1" href="../venta/venta-detalle.php?id_venta=<?php echo $rowh['id']; ?>" target="_blank" id="hover_enlace">
                                                                    <b class="">DETALLE</b>
                                                                </a>
                                                            </td>

                                                        </tr>
                                                        <?php
                                                        $total_flete_con += $rowh['flete_cliente'] + $rowh['flete_empresa'];
                                                        $total_venta_con += $total_venta;
                                                    }
                                                }
                                                ?>
                                            <tfoot>
                                                <tr>
                                                    <td class="text-end" colspan="2"><strong>TOTAL</strong></td>
                                                    <td class="text-end"><strong><?php echo number_format($total_venta_con, 0, ',', '.'); ?></strong></td>

                                                </tr>
                                            </tfoot>


                                            </tbody>
                                        </table>
                                    </div>


                                </div>
                            </div>
                        </div><!-- end col -->
                    </div><!-- end col -->
                </div><!-- end col -->
                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example1').DataTable({
                    "order": false,
                });


            });

        </script>

    </body>
</html>