<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Reporte de ventas por criterios</li>
                        </ol>
                    </nav>

                    <?php
                    if (isset($_POST['filtro'])) {
                        $nombre = $_POST['nombre'];

                        $nombre = trim($nombre);
                    } else {
                        $nombre = '';
                    }
                    ?>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-2 border rounded">

                                        <form method="POST" action="rpt-varios-criterios.php" class=" d-print-none">
                                            <div class="row">
                                                <div class="col-6 col-sm-4">
                                                    <div class="form-group">
                                                        <label><b>Busca por nombre, cedula, telefono, numero de guia o destino:</b></label>
                                                        <input type="text" class="form-control form-control-sm" name="nombre" value="<?php echo $nombre; ?>"required>  
                                                    </div>
                                                </div>
                                                <div class="col-5 col-sm-1">
                                                    <div class="form-group">
                                                        <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                            Consultar
                                                        </button>  
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    if (isset($_POST['filtro'])) {

                        $nombre = $_POST['nombre'];

                        $nombre = trim($nombre);

                        $sql = " (id LIKE '%" . $nombre . "%' OR cedula LIKE '%" . $nombre . "%' OR nombre LIKE '%" . $nombre . "%' OR numero_guia LIKE '%" . $nombre . "%' OR telefono LIKE '%" . $nombre . "%' OR destino LIKE '%" . $nombre . "%')";
                        ?>


                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table align-middle mb-0 table-bordered" id="example2">
                                                <thead class="">
                                                    <tr class="bg-tianzi text-dark">
                                                        <th class="text-center">ID</th>
                                                        <th class="text-center">FECHA</th>
                                                        <th class="text-center">CEDULA</th>
                                                        <th class="text-center">CLIENTE</th>
                                                        <th class="text-center">DESTINO</th>
                                                        <th class="text-center">FLETES</th>
                                                        <th class="text-center">TRANSPORTADORA</th>
                                                        <th class="text-center">TOTAL</th>
                                                        <th class="text-center">ESTADO</th>
                                                        <th class="text-center">ASESOR / A</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $sql = "SELECT * FROM venta WHERE $sql";
                                                    $query = $conn->query($sql);
                                                    if ($query->num_rows > 0) {
                                                        while ($row = $query->fetch_assoc()) {

                                                            $sqlr1 = "SELECT SUM(cantidad * precio_unidad) as total_venta FROM venta_detalle WHERE id_venta='" . $row['id'] . "'";
                                                            $queryr1 = $conn->query($sqlr1);
                                                            $rowr1 = $queryr1->fetch_assoc();

                                                            $sqlr2 = "SELECT * FROM usuario WHERE nombre='" . $row['nombre_usuario'] . "'";
                                                            $queryr2 = $conn->query($sqlr2);
                                                            $rowr2 = $queryr2->fetch_assoc();
                                                            ?>
                                                            <tr> 
                                                                <td class="">
                                                                    <a href="../venta/venta-detalle.php?id_venta=<?php echo $row['id']; ?>" target="_blank">
                                                                        <b>
                                                                            <?php echo $row['id']; ?>
                                                                        </b>
                                                                    </a>
                                                                </td>
                                                                <td class="text-center"><?php echo $row['fecha']; ?></td>
                                                                <td class="">
                                                                    <i class=" fas fa-id-card"></i> 
                                                                    <?php echo $row['cedula']; ?>
                                                                </td>
                                                                <td class="">
                                                                    <i class="fas fa-user"></i>
                                                                    <?php echo $row['nombre']; ?> 
                                                                </td> 
                                                                <td class="">
                                                                    <i class=" fas fa-map-marker-alt"></i>
                                                                    <?php echo $row['destino']; ?>
                                                                    <br>
                                                                    <i class=" fas fa-phone-alt"></i> 
                                                                    <?php echo $row['telefono']; ?>
                                                                </td>
                                                                <td class="">
                                                                    <strong>Cliente:</strong> <?php echo number_format($row['flete_cliente'], 0, ',', '.'); ?><br>
                                                                    <strong>Empresa:</strong> <?php echo number_format($row['flete_empresa'], 0, ',', '.'); ?>

                                                                </td>
                                                                <td class="text-center">

                                                                    <strong>

                                                                        <?php
                                                                        if ($row['caja_transportador'] == 'INTERRAPIDISIMO') {
                                                                            ?>
                                                                            <img src="../../img/LOGO-INTERRAPIDISIMO.jpg" width="120" class="" alt="" />
                                                                            <?php
                                                                        } elseif ($row['caja_transportador'] == 'ENVIA') {
                                                                            ?>
                                                                            <img src="../../img/Envia.png" width="80" class="" alt="" />
                                                                            <?php
                                                                        } elseif ($row['caja_transportador'] == 'AVEONLINE') {
                                                                            ?>
                                                                            <img src="../../img/Aveonline.png" width="100" class="" alt="" />
                                                                            <?php
                                                                        } elseif ($row['caja_transportador'] == 'SERVIENTREGA') {
                                                                            ?>
                                                                            <img src="../../img/Servientrega.png" width="120" class="" alt="" />
                                                                            <?php
                                                                        } elseif ($row['caja_transportador'] == NULL) {

                                                                            echo 'No aplica';
                                                                        } else {
                                                                            echo $row['caja_transportador'];
                                                                        }
                                                                        ?> 
                                                                    </strong><br>
                                                                    <?php echo $row['numero_guia']; ?>

                                                                </td>
                                                                <td class="text-end">
                                                                    <strong style="color:gray;">$</strong>
                                                                    <?php echo number_format($rowr1['total_venta'] + $row['flete_cliente'], 0, ',', '.'); ?>
                                                                </td>                   
                                                                <td class="text-center">
                                                                    <?php
                                                                    if ($row['estado'] == 'Proceso') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-info';
                                                                    } elseif ($row['estado'] == 'Confirmado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-pink';
                                                                    } elseif ($row['estado'] == 'Alistamiento') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-primary';
                                                                    } elseif ($row['estado'] == 'Enviado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-warning';
                                                                    } elseif ($row['estado'] == 'Novedad') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-bronze';
                                                                    } elseif ($row['estado'] == 'Entregado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-success';
                                                                    } elseif ($row['estado'] == 'Cancelado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-secondary';
                                                                    } elseif ($row['estado'] == 'Devolucion') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-dark';
                                                                    } else {
                                                                        $text = 'text-dark';
                                                                    }
                                                                    ?>

                                                                    <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>
                                                                </td>
                                                                <td class="text-center"><b class="text-secondary"><?php echo $rowr2['nombre']; ?></b></td>

                                                            </tr>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    } else {
                        ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <h5> No hay resultados para mostrar</h5>
                            </div>
                        </div>

                        <?php
                    }
                    ?>
                </div>


                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    buttons: ['excel', 'pdf'],
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>