<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_tercero = $_GET['nombre_tercero'];
    $estado = $_GET['estado'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <div class="container-fluid p-5 ">

            <div class="page-content">

                <nav aria-label="breadcrumb" class="d-print-none">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="../inicio/inicio.php"> 
                                <ion-icon name="home-outline"></ion-icon>
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">RPT - Pedido por detalle</li>
                    </ol>
                </nav>

                <div class="card d-print-none">
                    <div class="card-body text-center">
                        <h3><b> PEDIDOS DETALLADO POR CLIENTE</b></h3>
                    </div>
                </div>

                <div class="row d-print-none">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2 border rounded ">
                                    <form method="GET" action="rpt-pedido-detalle.php" class=" d-print-none">
                                        <div class="row">
                                            <div class="col-6 col-sm-2 ">
                                                <div class="form-group">
                                                    <label>Desde</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>Hasta</label>
                                                    <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                </div>
                                            </div>

                                            <div class="col-sm-5">
                                                <div class="form-group">
                                                    <label>TERCERO</label>
                                                    <select class="single-select form-control-sm" name="nombre_tercero" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($nombre_tercero != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $nombre_tercero; ?>"><?php echo $nombre_tercero; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>

                                                            <?php
                                                        }



                                                        $sql6m = "SELECT * FROM alm_tercero";
                                                        $query6m = $conn->query($sql6m);
                                                        if ($query6m->num_rows > 0) {
                                                            while ($row6m = $query6m->fetch_assoc()) {
                                                                ?>
                                                                <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-6 col-sm-2">
                                                <div class="form-group">
                                                    <label>ESTADO</label>
                                                    <select class="single-select form-control-sm" name="estado" required autofocus="">

                                                        <?php
                                                        if (isset($_GET['filtro'])) {

                                                            if ($estado != 'todo') {
                                                                ?>
                                                                <option value="<?php echo $estado; ?>"><?php echo $estado; ?></option>
                                                                <option value="" disabled="" >Seleccione</option>
                                                                <option value="TODO" >TODO</option>

                                                                <?php
                                                            } else {
                                                                ?>

                                                                <option value="" disabled="" selected="">Seleccione</option>
                                                                <option value="TODO" >TODO</option>
                                                                <?php
                                                            }
                                                        } else {
                                                            ?>
                                                            <option value="" disabled="" selected="">Seleccione</option>
                                                            <option value="TODO" >TODO</option>
                                                            <?php
                                                        }
                                                        ?>

                                                        <option value="Proceso">Proceso</option>
                                                        <option value="Confirmado">Confirmado</option>
                                                        <option value="Cancelado">Cancelado</option>


                                                    </select>  
                                                </div>
                                            </div>
                                            <div class="col-5 col-sm-1 pt-3">
                                                <div class="form-group">
                                                    <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                        Consultar
                                                    </button>  
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="card ">
                    <div class="card-body">





                        <?php
                        if (isset($_GET['filtro'])) {

                            $fecha_desde = $_GET['fecha_desde'];
                            $fecha_hasta = $_GET['fecha_hasta'];
                            $nombre_tercero = $_GET['nombre_tercero'];

                            if ($nombre_tercero == 'TODO') {
                                $sql_nombre_tercero = "";
                            } else {
                                $sql_nombre_tercero = " AND p.nombre_tercero='" . $nombre_tercero . "'";
                            }

                            if ($estado == 'TODO') {
                                $sql_estado = "";
                            } else {
                                $sql_estado = " AND p.estado='" . $estado . "'";
                            }


                            $sql_fecha = "AND p.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";

                            $sql = $sql_fecha . $sql_nombre_tercero . $sql_estado;
                            ?>
                            <div class=" mt-3">
                                <div class="d-print-none">
                                    <div class="float-end">
                                        <a href="javascript:window.print()" class="btn btn-info waves-effect waves-light">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>


                                <?php
                                if ($nombre_tercero == 'TODO') {
                                    $nit = 'No aplica';
                                } else {
                                    $sqlter = "SELECT * FROM alm_tercero WHERE nombre='$nombre_tercero'";
                                    $queryter = $conn->query($sqlter);
                                    $rowter = $queryter->fetch_assoc();

                                    $nit = $rowter['nit'];
                                }
                                ?>
                                <div class="p-2 rounded">




                                    <div class="row">
                                        <div class="col-sm-2 text-center">
                                            <img src="../../img/logo.png" class="logo-icon"  alt="logo icon" width="80">

                                        </div> 

                                        <div class="col-sm-8 text-start">
                                            <h6 class="text-dark mt-0 mb-1"><b>REPORTE DE PEDIDOS</b></h6>

                                            <h6 class="text-dark mt-0 mb-1"><b> <?php echo $nombre_tercero; ?></b></h6>  
                                            <h6 class="text-dark mt-0 mb-1"><b>NIT: </b><?php echo $nit; ?></h6> 
                                            <h6 class="text-dark mt-0 mb-0">
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> 
                                                <b class="ms-3 me-3">|</b> 
                                                <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>
                                            </h6> 

                                        </div>
                                    </div>
                                </div>

                                <style>
                                    #hover_enlace:hover{
                                        color: purple;
                                        border-radius: 10px; 
                                        box-shadow: 0px 0px 10px 0px purple;
                                    }



                                </style>

                                <div class="  " style="overflow: auto;"> 
                                    <table class="table table-hover text-sm table-sm table-striped table-bordered mt-5 " style="width: 100%;" id="example2">
                                        <thead>

                                            <tr class="bg-gradient-warning text-dark">
                                                <th class=" p-1 "  >REFERENCIA</th>

                                                <?php
                                                $item = 0;
                                                $sqlt1 = "SELECT pd.talla "
                                                        . "FROM alm_pedido_detalle pd, alm_pedido p "
                                                        . "WHERE p.id=pd.id_pedido $sql GROUP BY pd.talla ORDER BY pd.talla asc";
                                                $queryt1 = $conn->query($sqlt1);
                                                if ($queryt1->num_rows > 0) {
                                                    while ($rowt1 = $queryt1->fetch_assoc()) {
                                                        ?>
                                                        <th class="text-center p-1"><?php echo $rowt1['talla']; ?></th>
                                                        <?php
                                                        $item++;
                                                    }
                                                }
                                                ?>
                                                <th class="text-center p-1" style="width: 5%;">T. PARES</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $total_cantidad = 0;
                                            $total_venta = 0;
                                            $sql1 = "SELECT pd.referencia_producto "
                                                    . "FROM alm_pedido_detalle pd, alm_pedido p "
                                                    . "WHERE p.id=pd.id_pedido $sql GROUP BY pd.referencia_producto";
                                            $query1 = $conn->query($sql1);
                                            if ($query1->num_rows > 0) {
                                                while ($row1 = $query1->fetch_assoc()) {

                                                    $sql2 = "SELECT * FROM producto WHERE referencia='" . $row1['referencia_producto'] . "'";
                                                    $query2 = $conn->query($sql2);
                                                    $row2 = $query2->fetch_assoc();

                                                    ////CANTIDAD POR REFERENCIA
                                                    $sqlCANT = "SELECT SUM(pd.cantidad) as cantidad_referencia "
                                                            . "FROM alm_pedido_detalle pd, alm_pedido p "
                                                            . "WHERE p.id=pd.id_pedido $sql AND pd.referencia_producto='" . $row1['referencia_producto'] . "'";
                                                    $queryCANT = $conn->query($sqlCANT);
                                                    $rowCANT = $queryCANT->fetch_assoc();
                                                    ?>
                                                    <tr class="align-middle">
                                                     
                                                        <td> 
                                                            <strong class="text-dark"><?php echo $row2['referencia']; ?></strong>
                                                        </td>

                                                        <?php
                                                        $queryt2 = $conn->query($sqlt1);
                                                        if ($queryt2->num_rows > 0) {
                                                            while ($rowt2 = $queryt2->fetch_assoc()) {

                                                                $sqlt4 = "SELECT SUM(pd.cantidad) as suma_talla  "
                                                                        . "FROM alm_pedido_detalle pd, alm_pedido p "
                                                                        . "WHERE p.id=pd.id_pedido $sql AND pd.referencia_producto='" . $row1['referencia_producto'] . "' AND pd.talla='" . $rowt2['talla'] . "'";
                                                                $queryt4 = $conn->query($sqlt4);
                                                                $rowt4 = $queryt4->fetch_assoc();

                                                                $suma_talla = $rowt4['suma_talla'];
                                                                ?>
                                                                <td class="ancho text-center">
                                                                    <b class="text-secondary"><?php echo $suma_talla; ?></b>
                                                                </td>
                                                                <?php
                                                            }
                                                        }
                                                        ?>
                                                        <td class="text-center"><b><?php echo number_format($rowCANT['cantidad_referencia']); ?></b></td>
                                                    </tr>
                                                    <?php
                                                    $total_cantidad += $rowCANT['cantidad_referencia'];
                                                }
                                            }
                                            ?>


                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-light-dark">
                                                <th colspan="<?php echo $item + 1; ?>" class="text-end">TOTAL</th>                                                                          
                                                <th class="text-center"><?php echo number_format($total_cantidad); ?></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>



                            </div>
                            <?php
                        } else {
                            
                        }
                        ?>


                    </div>
                </div>
            </div>

        </div>


        <?php echo include '../general/libreria-js.php'; ?>
  <script src="../../assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
        <script src="../../assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>


  <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    paging: false,
                    lengthChange: false,
                    "columnDefs": [
                        {"orderable": false, "targets": "_all"}, // Desactiva ordenamiento para todas las columnas
                    ],

                    order: [[<?php echo $item + 1; ?>, 'desc']],

                    buttons: [
                        {
                            extend: 'excel',
                            text: 'EXCEL',
                            filename: 'PEDIDO POR REFERENCIA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            filename: 'PEDIDO POR REFERENCIA  <?php echo strftime("%d - %B - %Y", strtotime($fecha_desde)); ?> al  <?php echo strftime("%d - %B - %Y", strtotime($fecha_hasta)); ?>', // Aquí defines el nombre del archivo
                            title: null,
                        }
                        ],

                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>


    </body>
</html>