<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

$estado = $_GET['estado'];

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
} else {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item"><a href="rpt-vendedores-fecha.php?fecha_desde=<?php echo $fecha_desde; ?>&&fecha_hasta=<?php echo $fecha_hasta; ?>">Reporte de vendedores</a></li>
                            <li class="breadcrumb-item active"><?php echo $estado; ?></li> 
                        </ol>
                    </nav>


                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-2 border rounded">

                                        <form method="GET" action="rpt-lista-venta-general.php" class=" d-print-none">
                                            <input type="text" class="form-control form-control-sm" name="estado" value="<?php echo $estado; ?>" required hidden="">  


                                            <div class="row">
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Desde</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                    </div>
                                                </div>
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Hasta</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                    </div>
                                                </div>
                                                <div class="col-5 col-sm-1 pt-3">
                                                    <div class="form-group">
                                                        <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                            Consultar
                                                        </button>  
                                                    </div>
                                                </div>
                                            </div>
                                        </form>



                                        <?php
                                        if (isset($_GET['filtro'])) {

                                            $fecha_desde = $_GET['fecha_desde'];
                                            $fecha_hasta = $_GET['fecha_hasta'];

                                            $sqlcf = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                            $sql1 = "v.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                        } else {
                                            $fecha_desde = $_GET['fecha_desde'];
                                            $fecha_hasta = $_GET['fecha_hasta'];

                                            $sqlcf = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                            $sql1 = "v.fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "'";
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-4">

                                </div>
                                <div class="col-sm-4">
                                    <h6 class=" mb-3 text-center"><b>Ventas <br><?php echo strftime("%d - %B - %Y", strtotime(date($fecha_desde))); ?> <strong class="text-info">al</strong> <?php echo strftime("%d - %B - %Y", strtotime(date($fecha_hasta))); ?></b></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end page title -->
                    <style>
                        #hover_enlace:hover{
                            color: orange;
                            border-radius: 10px; border: #3fc3ee 1px solid;
                            box-shadow: 0px 0px 5px 0px #3fc3ee;
                        }

                    </style>


                    <div class="row">
                        <div class="col-sm-4">           
                            <div class="card-box">


                                <?php
                                if ($estado == 'Proceso') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-info';
                                } elseif ($estado == 'Confirmado') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-pink';
                                } elseif ($estado == 'Alistamiento') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-primary';
                                } elseif ($estado == 'Enviado') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-warning';
                                } elseif ($estado == 'Novedad') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-bronze';
                                } elseif ($estado == 'Entregado') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-success';
                                } elseif ($estado == 'Cancelado') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-secondary';
                                } elseif ($estado == 'Devolucion') {
                                    $alert_text = 'text-white';
                                    $alert = 'bg-dark';
                                } else {
                                    $text = 'text-dark';
                                }
                                ?>

                                <table class="table mb-0 font-12 table-striped table-bordered table-sm mb-3" style="color: black;">
                                    <thead>
                                        <tr class="<?php echo $alert . " " . $alert_text; ?>">
                                            <th class="text-center font-15" ><?php echo $estado; ?></th>
                                        </tr>
                                    </thead>
                                </table>


                                <?php
                                $sqly = "SELECT YEAR(fecha) as fecha FROM venta WHERE estado='$estado' AND $sqlcf GROUP BY YEAR(fecha) ORDER BY fecha asc ";
                                $queryy = $conn->query($sqly);
                                if ($queryy->num_rows > 0) {
                                    while ($rowy = $queryy->fetch_assoc()) {

                                        $year = $rowy['fecha'];
                                        ?>

                                        <table class="table mb-0 font-12 table-striped table-bordered table-sm mb-3" style="color: black;">
                                            <thead>
                                                <tr class="">
                                                    <th class="text-center font-15" colspan="4"><?php echo $year; ?></th>
                                                </tr>
                                                <tr class="bg-light-primary text-primary">
                                                    <th class="text-center " >Mes</th>
                                                    <th class="text-center " >Monto ventas</th>
                                                    <th class="text-center " >Flete empresa</th>
                                                    <th class="text-center " >Neto ventas</th>
                                                </tr>
                                                <?php
                                                $total_venta_mes = 0;
                                                $total_flete_empresa_mes = 0;
                                                $total_neto_ventas_mes = 0;

                                                $sqlf = "SELECT MONTH(fecha) as fecha FROM venta WHERE  estado='$estado' AND $sqlcf AND YEAR(fecha)='$year' GROUP BY MONTH(fecha)  ORDER BY fecha asc ";
                                                $queryf = $conn->query($sqlf);
                                                if ($queryf->num_rows > 0) {
                                                    while ($rowf = $queryf->fetch_assoc()) {

                                                        if ($rowf['fecha'] == 1) {
                                                            $text_fecha = 'Enero';
                                                        } elseif ($rowf['fecha'] == 2) {
                                                            $text_fecha = 'Febrero';
                                                        } elseif ($rowf['fecha'] == 3) {
                                                            $text_fecha = 'Marzo';
                                                        } elseif ($rowf['fecha'] == 4) {
                                                            $text_fecha = 'Abril';
                                                        } elseif ($rowf['fecha'] == 5) {
                                                            $text_fecha = 'Mayo';
                                                        } elseif ($rowf['fecha'] == 6) {
                                                            $text_fecha = 'Junio';
                                                        } elseif ($rowf['fecha'] == 7) {
                                                            $text_fecha = 'Julio';
                                                        } elseif ($rowf['fecha'] == 8) {
                                                            $text_fecha = 'Agosto';
                                                        } elseif ($rowf['fecha'] == 9) {
                                                            $text_fecha = 'Septiembre';
                                                        } elseif ($rowf['fecha'] == 10) {
                                                            $text_fecha = 'Octubre';
                                                        } elseif ($rowf['fecha'] == 11) {
                                                            $text_fecha = 'Noviembre';
                                                        } elseif ($rowf['fecha'] == 12) {
                                                            $text_fecha = 'Diciembre';
                                                        }


                                                        $sql3 = "SELECT SUM(total_venta) as total_venta FROM venta WHERE estado='$estado' AND MONTH(fecha)='" . $rowf['fecha'] . "' AND YEAR(fecha)='$year'";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();

                                                        $sql4 = "SELECT SUM(flete_empresa) as flete_empresa FROM venta WHERE estado='$estado' AND MONTH(fecha)='" . $rowf['fecha'] . "' AND YEAR(fecha)='$year'";
                                                        $query4 = $conn->query($sql4);
                                                        $row4 = $query4->fetch_assoc();
                                                        ?>

                                                        <tr>
                                                            <th class=""><?php echo $text_fecha; ?></th>
                                                            <td class="text-end"><?php echo number_format($row3['total_venta'], 0, '.', ','); ?></td>
                                                            <td class="text-end"><?php echo number_format($row4['flete_empresa'], 0, '.', ','); ?></td>
                                                            <td class="text-end"><?php echo number_format($row3['total_venta'] - $row4['flete_empresa'], 0, '.', ','); ?></td>
                                                        </tr>
                                                        <?php
                                                        $total_venta_mes += $row3['total_venta'];
                                                        $total_flete_empresa_mes += $row4['flete_empresa'];
                                                        $total_neto_ventas_mes += $row3['total_venta'] - $row4['flete_empresa'];
                                                    }
                                                }
                                                ?>

                                            </thead>
                                            <tfoot>
                                                <tr class="">
                                                    <th class="text-end">TOTAL</th>
                                                    <th class="text-end"><?php echo number_format($total_venta_mes, 0, '.', ','); ?></th>
                                                    <th class="text-end"><?php echo number_format($total_flete_empresa_mes, 0, '.', ','); ?></th>
                                                    <th class="text-end"><?php echo number_format($total_neto_ventas_mes, 0, '.', ','); ?></th>

                                                </tr>
                                            </tfoot>
                                        </table>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>

                        <div class="col-sm-8">
                            <style>
                                .badge-orange{
                                    background-color: orange;
                                }

                                .badge-yellow{
                                    background-color: yellow;
                                }
                            </style>

                            <div class="card-box">
                                <div class="">
                                    <table class="table mb-0 font-12 table-striped table-bordered table-sm" id="datatable" style="color: black;">
                                        <thead>
                                            <tr class="<?php echo $alert . " " . $alert_text; ?>">
                                                <th class="text-center font-15" colspan="9"><?php echo $estado; ?></th>
                                            </tr>
                                            <tr class="bg-light-primary text-primary">
                                                <th class="text-center">Orden</th>
                                                <th class="text-center" style="width: 10%;">Fecha</th>

                                                <th class="text-center">Cliente</th>


                                                <th class="text-center">Destino</th>
                                                <th class="text-center">Transportadora</th>
                                                <th class="text-center">Cant.</th>
                                                <th class="text-center">T.venta</th>
                                                <th class="text-center">Flete empresa</th>
                                                <th class="text-center">Asesor</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $cantidad_prendas = 0;

                                            $total_envio_empresa = 0;
                                            $total_venta = 0;

                                            $sql = "SELECT * FROM venta WHERE estado='$estado' AND $sqlcf";
                                            $query = $conn->query($sql);
                                            if ($query->num_rows > 0) {
                                                while ($row = $query->fetch_assoc()) {

                                                    $sqlr3 = "SELECT SUM(cantidad) cantidad_prendas FROM venta_detalle WHERE id_venta='" . $row['id'] . "'";
                                                    $queryr3 = $conn->query($sqlr3);
                                                    $rowr3 = $queryr3->fetch_assoc();
                                                    ?>
                                                    <tr> 
                                                        <td class="text-center">
                                                            <a href="../venta/venta-detalle.php?id_venta=<?php echo $row['id']; ?>" target="_blank">
                                                                <b><?php echo $row['id']; ?></b>
                                                            </a>
                                                        </td>
                                                        <td class="text-center"><?php echo $row['fecha']; ?></td>

                                                        <td class="">
                                                            <?php echo $row['nombre']; ?>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php echo $row['destino']; ?>
                                                        </td> 
                                                        <td class="text-center">
                                                            <strong>

                                                                <?php
                                                                if ($row['caja_transportador'] == 'INTERRAPIDISIMO') {
                                                                    ?>
                                                                    <img src="../../img/LOGO-INTERRAPIDISIMO.jpg" width="120" class="" alt="" />
                                                                    <?php
                                                                } elseif ($row['caja_transportador'] == 'ENVIA') {
                                                                    ?>
                                                                    <img src="../../img/Envia.png" width="80" class="" alt="" />
                                                                    <?php
                                                                } elseif ($row['caja_transportador'] == 'AVEONLINE') {
                                                                    ?>
                                                                    <img src="../../img/Aveonline.png" width="100" class="" alt="" />
                                                                    <?php
                                                                } elseif ($row['caja_transportador'] == 'SERVIENTREGA') {
                                                                    ?>
                                                                    <img src="../../img/Servientrega.png" width="120" class="" alt="" />
                                                                    <?php
                                                                } elseif ($row['caja_transportador'] == NULL) {

                                                                    echo 'No aplica';
                                                                } else {
                                                                    echo $row['caja_transportador'];
                                                                }
                                                                ?> 
                                                            </strong><br>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php echo number_format($rowr3['cantidad_prendas'], 0, '.', ','); ?>
                                                        </td>


                                                        <td class="text-end" >
                                                            <?php echo number_format($row['total_venta'], 0, '.', ','); ?>
                                                        </td>  
                                                        <td class="text-end" >
                                                            <?php echo number_format($row['flete_empresa'], 0, '.', ','); ?>
                                                        </td>  
                                                        <td class="" >
                                                            <b class=""><?php echo $row['nombre_usuario']; ?></b>
                                                        </td> 
                                                    </tr>
                                                    <?php
                                                    $cantidad_prendas += $rowr3['cantidad_prendas'];
                                                    $total_venta += $row['total_venta'];
                                                    $total_envio_empresa += $row['flete_empresa'];
                                                }
                                            }
                                            ?>



                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th class="text-end" colspan="5">TOTALES</th>
                                                <th class="text-center"><?php echo number_format($cantidad_prendas, 0, ',', '.'); ?></th>
                                                <th class="text-end">$ <?php echo number_format($total_venta, 0, ',', '.'); ?></th>
                                                <th class="text-end">$ <?php echo number_format($total_envio_empresa, 0, ',', '.'); ?></th>

                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>


                            </div>


                        </div>
                    </div>

                </div><!-- end col -->
                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>
    </body>
</html>