<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';

if (isset($_GET['filtro'])) {
    $fecha_desde = $_GET['fecha_desde'];
    $fecha_hasta = $_GET['fecha_hasta'];
    $nombre_usuario = $_GET['nombre_usuario'];
} else {
    $fecha_desde = date("Y-m-d");
    $fecha_hasta = date("Y-m-d");
}
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Reporte de comision</li>
                        </ol>
                    </nav>


                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-2 border rounded">

                                        <form method="GET" action="rpt-comision-vendedor.php" class=" d-print-none">
                                            <div class="row">
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Desde</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_desde" value="<?php echo $fecha_desde; ?>" required>  
                                                    </div>
                                                </div>
                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Hasta</label>
                                                        <input type="date" class="form-control form-control-sm" name="fecha_hasta" value="<?php echo $fecha_hasta; ?>" required>  
                                                    </div>
                                                </div>


                                                <div class="col-6 col-sm-2">
                                                    <div class="form-group">
                                                        <label>Asesores</label>
                                                        <select class="form-control form-control-sm" name="nombre_usuario" required>

                                                            <?php
                                                            if (isset($_GET['filtro'])) {

                                                                if ($nombre_usuario != 'todo') {
                                                                    ?>
                                                                    <option value="<?php echo $nombre_usuario; ?>"><?php echo $nombre_usuario; ?></option>
                                                                    <option value="" disabled=""></option>
                                                                    <option value="todo">Todos</option>
                                                                    <?php
                                                                } else {
                                                                    ?>
                                                                    <option value="todo">Todos</option>
                                                                    <option value="" disabled=""></option>
                                                                    <?php
                                                                }
                                                            } else {
                                                                ?>
                                                                <option value="todo">Todos</option>
                                                                <option value="" disabled=""></option>
                                                                <?php
                                                            }
                                                            ?>

                                                            <?php
                                                            $sql6m = "SELECT * FROM usuario WHERE rol='asesor'";
                                                            $query6m = $conn->query($sql6m);
                                                            if ($query6m->num_rows > 0) {
                                                                while ($row6m = $query6m->fetch_assoc()) {
                                                                    ?>

                                                                    <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                        </select>  
                                                    </div>
                                                </div>

                                                <div class="col-5 col-sm-1 pt-3">
                                                    <div class="form-group">
                                                        <button class="btn btn-primary px-2 radius-30" type="submit" name="filtro" style="width: 100%;">
                                                            Consultar
                                                        </button>  
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>





                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    if (isset($_GET['filtro'])) {

                        $fecha_desde = $_GET['fecha_desde'];
                        $fecha_hasta = $_GET['fecha_hasta'];
                        $nombre_usuario = $_GET['nombre_usuario'];

                        
                        if ($nombre_usuario == 'todo') {
                            $sql_nombre_usuario = "";
                        }else{
                            $sql_nombre_usuario = " AND nombre_usuario='".$nombre_usuario."'";
                        }
                        
                        $sql_fecha = "fecha BETWEEN '" . $fecha_desde . "' AND '" . $fecha_hasta . "' ";
                        
                        $sql = $sql_fecha.$sql_nombre_usuario;
                        
                        ?>
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table align-middle mb-0 table-striped" id="example2" style="font-size: 12px;">
                                                <thead class="table-light">
                                                    <tr class="bg-light-primary text-primary">
                                                        <th class="text-center">Id</th>
                                                        <th class="text-center">Fecha</th>
                                                        <th class="text-center">Cedula</th>
                                                        <th class="text-center">Cliente</th>

                                                        <th class="text-center">Destino</th>
                                                        <th class="text-center">Fletes</th>
                                                        <th class="text-center">Transportadora</th>
                                                        <th class="text-center">Total</th>
                                                        <th class="">Estado</th>
                                                        <th class="">Asesor / a</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    $sql = "SELECT * FROM venta WHERE $sql AND estado='Entregado'";
                                                    $query = $conn->query($sql);
                                                    if ($query->num_rows > 0) {
                                                        while ($row = $query->fetch_assoc()) {

                                                            $sqlr1 = "SELECT SUM(cantidad * precio_unidad) as total_venta FROM venta_detalle WHERE id_venta='" . $row['id'] . "'";
                                                            $queryr1 = $conn->query($sqlr1);
                                                            $rowr1 = $queryr1->fetch_assoc();

                                                            $sqlr2 = "SELECT * FROM usuario WHERE nombre='" . $row['nombre_usuario'] . "'";
                                                            $queryr2 = $conn->query($sqlr2);
                                                            $rowr2 = $queryr2->fetch_assoc();
                                                            ?>
                                                            <tr> 
                                                                <td class="">
                                                                    <a href="../venta/venta-detalle.php?id_venta=<?php echo $row['id']; ?>" target="_blank">
                                                                        <b>
                                                                            ODP-<?php echo $row['id']; ?>
                                                                        </b>
                                                                    </a>
                                                                </td>
                                                                <td class="text-center"><?php echo $row['fecha']; ?></td>
                                                                <td class="">
                                                                    <i class=" fas fa-id-card"></i> 
                                                                    <?php echo $row['cedula']; ?>
                                                                </td>
                                                                <td class="">
                                                                    <i class="fas fa-user"></i>
                                                                    <?php echo $row['nombre']; ?> 
                                                                </td> 
                                                                <td class="">
                                                                    <i class=" fas fa-map-marker-alt"></i>
                                                                    <?php echo $row['destino']; ?>
                                                                    <br>
                                                                    <i class=" fas fa-phone-alt"></i> 
                                                                    <?php echo $row['telefono']; ?>
                                                                </td>
                                                                <td class="">
                                                                    <strong>Cliente:</strong> <?php echo number_format($row['flete_cliente'], 0, ',', '.'); ?><br>
                                                                    <strong>Empresa:</strong> <?php echo number_format($row['flete_empresa'], 0, ',', '.'); ?>

                                                                </td>
                                                                <td class="text-center">

                                                                    <?php
                                                                    if ($row['tercero_transportadora'] == 'Interrapidisimo transporte') {
                                                                        ?>
                                                                        <img src="../../img/LOGO-INTERRAPIDISIMO.jpg" width="120" class="" alt="" />
                                                                        <?php
                                                                    } elseif ($row['tercero_transportadora'] == 'Envia transporte') {
                                                                        ?>
                                                                        <img src="../../img/Envia.png" width="80" class="" alt="" />
                                                                        <?php
                                                                    } elseif ($row['tercero_transportadora'] == 'Aveonline trasnporte') {
                                                                        ?>
                                                                        <img src="../../img/Aveonline.png" width="100"  class="" alt="" />
                                                                        <?php
                                                                    } elseif ($row['tercero_transportadora'] == 'Servientrega transporte') {
                                                                        ?>
                                                                        <img src="../../img/Servientrega.png" width="120" class="" alt="" />
                                                                        <?php
                                                                    } elseif ($row['tercero_transportadora'] == NULL) {

                                                                        echo 'No aplica';
                                                                    } else {
                                                                        echo $row['tercero_transportadora'];
                                                                    }
                                                                    ?> 
                                                                    <br>
                                                                    <?php echo $row['numero_guia']; ?>

                                                                </td>
                                                                <td class="text-right">
                                                                    <strong style="color:gray;">$</strong>
                                                                    <?php echo number_format($rowr1['total_venta'] + $row['flete_cliente'], 0, ',', '.'); ?>
                                                                </td>                   
                                                                <td class="">
                                                                    <?php
                                                                    if ($row['estado'] == 'Proceso') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-info';
                                                                    } elseif ($row['estado'] == 'Confirmado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-pink';
                                                                    } elseif ($row['estado'] == 'Alistamiento') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-primary';
                                                                    } elseif ($row['estado'] == 'Enviado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-warning';
                                                                    } elseif ($row['estado'] == 'Novedad') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-bronze';
                                                                    } elseif ($row['estado'] == 'Entregado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-success';
                                                                    } elseif ($row['estado'] == 'Cancelado') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-secondary';
                                                                    } elseif ($row['estado'] == 'Devolucion') {
                                                                        $alert_text = 'text-white';
                                                                        $alert = 'bg-dark';
                                                                    } else {
                                                                        $text = 'text-dark';
                                                                    }
                                                                    ?>

                                                                    <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>
                                                                </td>
                                                                <td class=""><b class="text-secondary"><?php echo $rowr2['nombre']; ?></b></td>

                                                            </tr>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    } else {
                        ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <h5> No hay resultados para mostrar</h5>
                            </div>
                        </div>

                        <?php
                    }
                    ?>
                </div>


                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>