<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Panel de analisis</li>
                        </ol>
                    </nav>

                    <div class="row">
                        <div class="col-12 col-lg-4 col-xl-4">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                                    <h6><b>VENTAS / <?php echo strftime("%d - %B - %Y", strtotime(date("Y-m-d"))); ?></b></h6>

                                    <hr>
                                    <p>La meta diaria para vendedores es de $ <?php echo number_format($meta, 0) ?></p>
                                    <?php
                                    $total_monto = 0;
                                    $total_ordenes = 0;
                                    $total_prendas = 0;
                                    $sql7 = "SELECT * FROM alm_usuario WHERE mostrar='Si'";
                                    $query7 = $conn->query($sql7);
                                    if ($query7->num_rows > 0) {
                                        while ($row7 = $query7->fetch_assoc()) {


                                            $sql8 = "SELECT SUM(total_venta) as total_venta FROM alm_venta WHERE nombre_usuario='" . $row7['nombre'] . "' AND  fecha='" . date("Y-m-d") . "' ";
                                            $query8 = $conn->query($sql8);
                                            $row8 = $query8->fetch_assoc();

                                            $sql9 = "SELECT COUNT(id) as contar_venta FROM alm_venta WHERE  nombre_usuario='" . $row7['nombre'] . "' AND  fecha='" . date("Y-m-d") . "' ";
                                            $query9 = $conn->query($sql9);
                                            $row9 = $query9->fetch_assoc();

                                            $sql10 = "SELECT SUM(vd.cantidad) as cantidad_prendas
                                                    FROM alm_venta v, alm_venta_detalle vd
                                                    WHERE v.id=vd.id_venta AND v.nombre_usuario='" . $row7['nombre'] . "' AND v.fecha='" . date("Y-m-d") . "' ";
                                            $query10 = $conn->query($sql10);
                                            $row10 = $query10->fetch_assoc();

                                            if ($row8['total_venta'] <= 0) {
                                                $porcentaje1 = 0;
                                            } else {
                                                $porcentaje1 = 100 / ($meta / $row8['total_venta']);
                                            }




                                            $porcentaje1 = number_format($porcentaje1, 1);

                                            if ($porcentaje1 > 0 && $porcentaje1 < 20) {
                                                $porcentaje_color = 'bg-danger';
                                            } elseif ($porcentaje1 > 19 && $porcentaje1 < 80) {
                                                $porcentaje_color = 'bg-warning';
                                            } elseif ($porcentaje1 > 79 && $porcentaje1 < 100) {
                                                $porcentaje_color = 'bg-info';
                                            } elseif ($porcentaje1 > 99) {
                                                $porcentaje_color = 'bg-success';
                                            }
                                            ?>

                                            <style>
                                                #panel_estado_progreso:hover{
                                                    border-radius: 10px; border: #8ab0e9 2px solid;
                                                }

                                            </style>

                                            <?php
                                            if ($row8['total_venta'] <= 0) {
                                                ?>

                                                <?php
                                            } else {
                                                ?>
                                                <div class = "p-2" id = "panel_estado_progreso">
                                                    <a href = "rpt-vendedor.php?nombre_usuario=<?php echo $row7['nombre']; ?>&&fecha_desde=<?php echo date("Y-m-d"); ?>&&fecha_hasta=<?php echo date("Y-m-d"); ?>" >
                                                        <div class = "card radius-10 shadow-none mb-0 text-dark" >
                                                            <div class = "d-flex align-items-center gap-3">

                                                                <h6 class = "mb-0"><strong><?php echo $row7['nombre'];
                                                ?></strong></h6>
                                                                <div class="ms-auto"><strong>$ <?php echo number_format($row8['total_venta']); ?></strong></div>
                                                            </div>
                                                            <span class="text-secondary " style="font-size: 12px;"><?php echo $row9['contar_venta']; ?> Ordenes | <?php echo number_format($row10['cantidad_prendas'], 0, '.', ','); ?> Prendas</span>
                                                            <div class="progress">
                                                                <div class="progress-bar progress-bar-striped progress-bar-animated <?php echo $porcentaje_color; ?>" role="progressbar" style="width: <?php echo $porcentaje1; ?>%;" aria-valuenow="<?php echo $porcentaje1; ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $porcentaje1; ?>%</div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <hr>
                                                <?php
                                            }
                                            ?>



                                            <?php
                                            $total_monto += $row8['total_venta'];
                                            $total_ordenes += $row9['contar_venta'];
                                            $total_prendas += $row10['cantidad_prendas'];
                                        }
                                    }
                                    ?>
                                    <div class="inbox-item mt-3 p-2" id="hover_enlace" style="font-size: 12px;">
                                        <div class="row mb-0">
                                            <div class="col-7">
                                                <h5 class="inbox-item-author mt-0 mb-1"><b>TOTAL</b></h5>
                                                <p class="inbox-item-text"><?php echo $total_ordenes; ?> Ordenes | <?php echo number_format($total_prendas, 0, '.', ','); ?> Prendas</p>

                                            </div>
                                            <div class="col-5 text-end">
                                                <p class="inbox-item-date text-dark "><strong style="font-size: 16px;">$ <?php echo number_format($total_monto, 0, '.', ','); ?></strong></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>


                        <div class="col-12 col-lg-5 col-xl-5 ">
                            <div class="card radius-10 w-100">
                                <div class="card-body">
                            

                                </div>
                            </div>

                        </div><!-- end col -->




                        <div class="col-12 col-sm-3">
                            <div class="card radius-10 w-100">
                                <div class="card-body ">
                                    <h6 class="text-center"><b>REPORTES</b></h6>
                                    <hr>

                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>TERCEROS</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-kardex.php" class="text-dark">RPT - Kardex</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-pedido.php" class="text-dark">RPT - Pedidos</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-pedido-detalle.php" class="text-dark">RPT - Pedidos por detalle</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-venta.php" class="text-dark">RPT - Ventas</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-venta-detalle.php" class="text-dark">RPT - Ventas por detalle</a></li>
                                    </ul>


                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item bg-transparent "><strong>MERCANCIA</strong></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-mercancia-despachar.php" class="text-dark">RPT - Mercancia por despachar</a></li>
                                        <li class="list-group-item bg-transparent "><a href="rpt-mercancia-despachar-cliente.php" class="text-dark">RPT - Mercancia por despachar a cliente</a></li>
                                    </ul>

                                                                    <br>

                                    <div class="text-center">
                                        <a href="sincronizar.php" class="btn btn-primary radius-30 px-5 ">SINCORNIZAR</a>
                                    </div>

                                </div>
                            </div><!-- end col -->
                        </div>



                    </div>
                </div>
                <!-- end page content-->
            </div>
            <!--end page content wrapper-->

            <?php echo include '../general/footer.php'; ?>

        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>



        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example1').DataTable({
                    lengthChange: false,
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>