<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="empresa.php"> 
                                    Fabrica
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Pedido</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body text-center bg-gradient-warning">
                            <h3><b>PEDIDOS</b></h3>
                        </div>
                    </div>




                    <div class="card">
                        <div class="card-body">


                            <div class="row">
                                <div class="col-sm-9">
                                    <h6 class="mb-0 text-uppercase"><b>LISTA DE PEDIDOS</b></h6>

                                </div>
                                <div class="col-sm-3 text-end">
                                    <a href="#!" class="btn btn-primary px-5 radius-30" data-bs-toggle="modal" data-bs-target="#agregar" >
                                        NUEVO PEDIDO 
                                    </a> 

                                    <div class="modal fade text-start" id="agregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xs">
                                            <div class="modal-content">
                                                <div class="modal-header bg-gradient-warning">
                                                    <h5 class="modal-title card-heading text-dark" id="exampleModalLabel">NUEVO PEDIDO</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form method="POST" action="script/pedido-guardar.php" class="row g-3 needs-validation ">
                                                    <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                                    <div class="modal-body ">
                                                        <div class="row">
                                                            <div class="col-md-6">
                                                                <label class="form-label" for="validationCustom02">Fecha</label>
                                                                <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>" autofocus="" readonly="">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="form-label" for="validationCustom02">Numero pedido</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required="" name="numero_pedido" value="Opcional" readonly="">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required="" name="nombre_tercero" value="INNOVASUELAS ALMACEN" readonly="">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Observaci��n</label>
                                                                <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion">No aplica</textarea>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-success px-5 radius-30" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>


                            <hr/>

                            <style>
                                #hover_enlace:hover{
                                    color: purple;
                                    border-radius: 10px; 
                                    box-shadow: 0px 0px 10px 0px purple;
                                }



                            </style>

                            <div class=" mt-2 " style="overflow: auto;"> 
                                <table class="table  table-striped table-bordered "  border="1" id="example2" style="width: 100%;">
                                    <thead class="">
                                        <tr class=" text-dark bg-gradient-warning">
                                            <th class="text-center " style="">FECHA</th>

                                            <th class="text-center ">ID PEDIDO</th>
                                            <th class="text-center">No PEDIDO</th>
                                            <th class="" style="">TERCERO</th>

                                            <th class="">OBSERVACION</th>
                                            <th class="text-center">CANT.</th>
                                            <th class="text-center">ESTADO</th>
                                            <th class="text-center">DETALLE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM pedido WHERE nombre_tercero='INNOVASUELAS ALMACEN' ORDER BY fecha desc, id desc";
                                        $query = $conn->query($sql);
                                        if ($query->num_rows > 0) {
                                            while ($row = $query->fetch_assoc()) {
                                                ?>
                                                <tr class="align-middle" id="hover_enlace" >
                                                    <td class="text-center">
                                                        <?php echo date('d-m-Y', strtotime($row['fecha'])); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        ODP <?php echo $row['id']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <b><?php echo $row['numero_pedido']; ?></b>
                                                    </td> 

                                                    <td class="">
                                                        <?php echo $row['nombre_tercero']; ?>
                                                    </td>    


                                                    <td class="">
                                                        <?php echo $row['observacion']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php
                                                        $sql3 = "SELECT SUM(cantidad) as cantidad_pedido FROM pedido_detalle WHERE id_pedido='" . $row['id'] . "'";
                                                        $query3 = $conn->query($sql3);
                                                        $row3 = $query3->fetch_assoc();

                                                        echo number_format($row3['cantidad_pedido'], 0);
                                                        ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php
                                                        if ($row['estado'] == 'Proceso') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-info';
                                                        } elseif ($row['estado'] == 'Confirmado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-pink';
                                                        }  elseif ($row['estado'] == 'Recibido') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-success';
                                                        }  elseif ($row['estado'] == 'Cancelado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-secondary';
                                                        }  else {
                                                            $text = 'text-dark';
                                                        }
                                                        ?>
                                                        <span class="badge <?php echo $alert; ?>"><?php echo $row['estado']; ?></span>

                                                    </td>
                                                    <td class="text-center">
                                                        <a href="pedido-detalle.php?id_pedido=<?php echo $row['id']; ?>">
                                                            <i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>

                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                    'autoWidth': false,

                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    }
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>