<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>

        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">


                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Fabrica</li>
                        </ol>
                    </nav>

                    <div class="card">
                        <div class="card-body ">
                            <h4 class="text-center "><b>TALLER INNOVASUELAS</b></h4>
                        </div>
                    </div>



                    <style>
                        #hover_enlace:hover{
                            color: purple;
                            border-radius: 10px;
                            box-shadow: 0px 0px 10px 0px purple;
                        }

                    </style>
                    <div class="card radius-10 w-100">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-3 mt-2">
                                    <div class="card radius-10   mb-0 bg-gradient-warning" id="hover_enlace">
                                        <a href="pedido.php">
                                            <div class="card-body text-white p-4">
                                                <div class="d-flex align-items-center gap-3">
                                                    <div class="fs-6">
                                                        <i class="fa-solid fa-arrows-to-dot"></i>
                                                    </div>
                                                    <h5 class="mb-0">Generar pedido</h5>

                                                    <div class="ms-auto"></div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-sm-3 mt-2">
                                    <div class="card radius-10  mb-0 bg-gradient-warning" id="hover_enlace">
                                        <a href="pedido.php">
                                            <div class="card-body text-white p-4">
                                                <div class="d-flex align-items-center gap-3">
                                                    <div class="fs-6">
                                                        <i class="fa-solid fa-file-lines"></i>
                                                    </div>
                                                    <h5 class="mb-0">Pedidos</h5>
                                                    <?php
                                                    $sql = "SELECT COUNT(id) as contar_pedido FROM pedido WHERE nombre_tercero='INNOVASUELAS ALMACEN'";
                                                    $query = $conn->query($sql);
                                                    $row = $query->fetch_assoc();
                                                    ?>
                                                    <div class="ms-auto"><?php echo number_format($row['contar_pedido'], 0); ?></div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-sm-3 mt-2">
                                    <div class="card radius-10  mb-0 bg-gradient-info" id="hover_enlace">
                                        <a href="despacho.php">
                                            <div class="card-body text-white p-4">
                                                <div class="d-flex align-items-center gap-3">
                                                    <div class="fs-6">
                                                        <i class="fa-solid fa-truck-fast"></i>
                                                    </div>
                                                    <h5 class="mb-0">Despachos</h5>
                                                    <?php
                                                    $sql1 = "SELECT COUNT(id) as contar_despacho FROM despacho WHERE nombre_tercero='INNOVASUELAS ALMACEN'";
                                                    $query1 = $conn->query($sql1);
                                                    $row1 = $query1->fetch_assoc();
                                                    ?>
                                                    <div class="ms-auto"><?php echo number_format($row1['contar_despacho'], 0); ?></div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-sm-3 mt-2">
                                    <div class="card radius-10  mb-0 bg-gradient-royal" id="hover_enlace">
                                        <a href="pendiente.php">
                                            <div class="card-body text-white p-4">
                                                <div class="d-flex align-items-center gap-3">
                                                    <div class="fs-6">
                                                        <i class="fa-solid fa-box-open"></i>
                                                    </div>
                                                    <h5 class="mb-0">Pendiente</h5>
                                                    <?php
                                                    ?>
                                                    <div class="ms-auto"><?php echo number_format(0, 0); ?></div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <?php echo include '../general/footer.php'; ?>
            </div>
            <!--end wrapper-->
            <?php echo include '../general/libreria-js.php'; ?>

    </body>
</html>
