<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
        <script type="text/javascript" src="https://jeremyfagis.github.io/dropify/dist/js/dropify.min.js"></script>
        <link rel="stylesheet" type="text/css" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="../inicio/inicio.php"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="empresa.php"> 
                                    Fabrica
                                </a>
                            </li>

                            <li class="breadcrumb-item">
                                Despachos
                            </li>
                        </ol>
                    </nav>



                    <div class="card">
                        <div class="card-body text-center bg-gradient-info text-white">
                            <h3><b>DESPACHOS</b></h3>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-body">

                            <div class="row">
                                <div class="col-sm-9">
                                    <h6 class="mb-0 text-uppercase"><b>LISTA DE DESPACHOS</b> 
                                    </h6>

                                </div>
                                <div class="col-sm-3 text-end">
                                    <a href="#!" class="btn btn-primary px-5 radius-30" data-bs-toggle="modal" data-bs-target="#agregar" >
                                        NUEVO DESPACHO 
                                    </a> 

                                    <div class="modal fade text-start" id="agregar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xs">
                                            <div class="modal-content">
                                                <div class="modal-header bg-gradient-info">
                                                    <h5 class="modal-title card-heading text-dark" id="exampleModalLabel">NUEVO DESPACHO</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form class=" g-3 needs-validation" method="POST" action="script/despacho-guardar.php">
                                                    <div class="modal-body ">
                                                        <div class="row">
                                                            <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                                            <div class="col-sm-6">
                                                                <label class="form-label" for="validationCustom02">Fecha</label>
                                                                <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                            </div>
                                                            <div class="col-sm-6 ">
                                                                <label class="form-label" for="validationCustom02">Numero despacho</label>
                                                                <input class="form-control" id="validationCustom02" type="text" required="" name="numero_despacho" value="No aplica">
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                            </div>
                                                            <div class="col-sm-12 mt-3">
                                                                <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                                <select class="form-select" id="validationCustom04" required="" name="nombre_tercero">
                                                                    <option disabled="" selected="" value="">Seleccione</option>
                                                                    <?php
                                                                    $sql6m = "SELECT * FROM tercero";
                                                                    $query6m = $conn->query($sql6m);
                                                                    if ($query6m->num_rows > 0) {
                                                                        while ($row6m = $query6m->fetch_assoc()) {
                                                                            ?>

                                                                            <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                                            <?php
                                                                        }
                                                                    }
                                                                    ?>
                                                                </select>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                                            </div>
                                                            <div class="col-md-12 mt-3">
                                                                <label class="form-label" for="validationCustom02">Observación</label>
                                                                <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion">No aplica</textarea>
                                                                <div class="valid-feedback">Se ve bien!</div>
                                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-success px-5 radius-30" >Guardar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <hr/>

                            <style>
                                #hover_enlace:hover{
                                    color: purple;
                                    border-radius: 10px;
                                    box-shadow: 0px 0px 10px 0px purple;
                                }

                            </style>

                            <div class=" mt-2" style="overflow: auto;">
                                <table class="table mb-0 table-striped table-bordered" border="1" id="example2" style="width: 100%;" >
                                    <thead class="">
                                        <tr class="bg-gradient-info text-white">
                                            <th class="text-center" style="width: 10%;">FECHA</th>
                                            <th class="text-center ">ID</th>
                                            <th class="text-center " style="width: 10%;">No DESPACHO</th>
                                            <th class=" ">TERCERO</th>
                                            <th class="text-center ">DESTINO</th>
                                            <th class=" ">DIRECCION</th>
                                            <th class="">OBSERVACION</th>
                                            <th class="text-center">CANT.</th>
                                            <th class="text-center">PAQUETES</th>
                                            <th class="text-center">ESTADO</th>
                                            <th class="text-center">DETALLE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql4 = "SELECT * FROM despacho WHERE nombre_tercero='INNOVASUELAS ALMACEN' ORDER BY fecha desc, id desc";
                                        $query4 = $conn->query($sql4);
                                        if ($query4->num_rows > 0) {
                                            while ($row4 = $query4->fetch_assoc()) {

                                                $sql5 = "SELECT SUM(cantidad) as cantidad FROM despacho_detalle WHERE id_despacho='" . $row4['id'] . "'";
                                                $query5 = $conn->query($sql5);
                                                $row5 = $query5->fetch_assoc();

                                                $sql7 = "SELECT SUM(cantidad) AS cantidad FROM despacho_paquete WHERE id_despacho='" . $row4['id'] . "'";
                                                $query7 = $conn->query($sql7);
                                                $row7 = $query7->fetch_assoc();
                                                ?>
                                                <tr class="align-middle" id="hover_enlace" >
                                                    <td class="text-center">
                                                        <?php echo date('d-m-Y', strtotime($row4['fecha'])); ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo $row4['id']; ?>
                                                    </td>

                                                    <td class="text-center">
                                                        <b><?php echo $row4['numero_despacho']; ?></b>
                                                    </td>
                                                    <td class="" style="">
                                                        <?php echo $row4['nombre_tercero']; ?>
                                                    </td>         
                                                    <td class="text-center">
                                                        <?php echo $row4['destino']; ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php echo $row4['direccion']; ?>
                                                    </td> 
                                                    <td class="">
                                                        <?php echo $row4['observacion']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo $row5['cantidad']; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <?php echo number_format($row7['cantidad'], 0); ?>
                                                    </td>

                                                    <td class="text-center">
                                                        <?php
                                                        if ($row4['estado'] == 'Proceso') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-info';
                                                        } elseif ($row4['estado'] == 'Enviado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-warning';
                                                        } elseif ($row4['estado'] == 'Recibido') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-success';
                                                        } elseif ($row4['estado'] == 'Cancelado') {
                                                            $alert_text = 'text-white';
                                                            $alert = 'bg-secondary';
                                                        } else {
                                                            $text = 'text-dark';
                                                        }
                                                        ?>
                                                        <span class="badge <?php echo $alert; ?>"><?php echo $row4['estado']; ?></span>

                                                    </td>
                                                    <td class="text-center">
                                                        <a href="despacho-detalle.php?id_despacho=<?php echo $row4['id']; ?>"><i class="fa-solid fa-arrow-right-to-bracket fa-2x"></i></a>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </tbody>
                                </table>

                            </div>

                        </div>
                    </div>


                </div>
                <?php echo include '../general/footer.php'; ?>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>


        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,

                    language: {
                        search: 'Buscar',
                        zeroRecords: 'No hay registros para mostrar.',
                        emptyTable: 'La tabla está vacia.',
                        info: "Mostrando _START_ de _END_ de _TOTAL_ Registros.",
                        infoFiltered: "(Filtrados de _MAX_ Registros.)",
                        paginate: {
                            first: 'Primero',
                            previous: 'Anterior',
                            next: 'Siguiente',
                            last: 'Último'
                        }
                    }
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>