<?php
session_start();
include '../../script/conexion.php';
require '../general/validacion.php';
?>
<!doctype html>
<html lang="en" class="light-theme">
    <head>
        <?php include '../general/libreria-css.php'; ?>
    </head>
    <body>
        <!--start wrapper-->
        <div class="wrapper">
            <?php echo include '../general/menu.php'; ?>

            <!-- start page content wrapper-->
            <div class="page-content-wrapper">
                <!-- start page content-->
                <div class="page-content">

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#"> 
                                    <ion-icon name="home-outline"></ion-icon>
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Compras</li>
                        </ol>
                    </nav>


                    <div class="card">
                        <div class="card-body bg-tianzi-claro">
                            <h4 class="text-center"><b>COMPRAS</b></h4>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-xl-4 mx-auto">
                            <div class="card">
                                <div class="card-body">
                                    <h6 class="mb-0 text-uppercase">Nueva compra</h6>
                                    <hr/>
                                    <div class="p-4 border rounded">
                                        <form method="POST" action="script/compra-guardar.php" class="row g-3 needs-validation ">
                                            <input type="text" required="" name="nombre_usuario" value="<?php echo $rowusu['nombre']; ?>" hidden>
                                            <div class="col-md-12">
                                                <label class="form-label" for="validationCustom02">Fecha</label>
                                                <input class="form-control" id="validationCustom02" type="date" required="" name="fecha" value="<?php echo date('Y-m-d'); ?>">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label" for="validationCustom01">Nombre tercero</label>
                                                <select class="form-select custom-select" id="validationCustom04" required="" name="nombre_tercero">
                                                    <option selected="" disabled="" value="">Seleccione</option>
                                                    <?php
                                                    $sql6m = "SELECT * FROM alm_tercero";
                                                    $query6m = $conn->query($sql6m);
                                                    if ($query6m->num_rows > 0) {
                                                        while ($row6m = $query6m->fetch_assoc()) {
                                                            ?>

                                                            <option value="<?php echo $row6m['nombre'] ?>"><?php echo $row6m['nombre'] ?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, seleccione una opcion.</div>
                                            </div>

                                            <div class="col-md-12">
                                                <label class="form-label" for="validationCustom02">Numero factura</label>
                                                <input class="form-control" id="validationCustom02" type="text" required="" name="numero_factura">
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>

                                            <div class="col-md-12 mb-3">
                                                <label class="form-label" for="validationCustom02">Observacion</label>
                                                <textarea class="form-control" id="validationCustom02" type="text" required="" name="observacion">No aplica</textarea>
                                                <div class="valid-feedback">Se ve bien!</div>
                                                <div class="invalid-feedback">Por favor, digite el dato.</div>
                                            </div>
                                            <div class="col-12 text-end">
                                                <button class="btn btn-success" type="submit">Guardar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-8">

                            <div class="card">
                                <div class="card-body">
                                    
                                    
                                     <div class="row">
                                        <div class="col-sm-8">
                                    <h6 class="mb-0 text-uppercase">Lista de compras</h6>

                                        </div>
                                        <div class="col-sm-4 text-end">

                                            <a href="compra-comparativo.php" class="alert alert-info">Comparativo</a>
                                        </div>
                                    </div>
                                    
                                    <hr/>

                                    <style>
                                        #hover_enlace:hover{
                                            color: purple;
                                            border-radius: 10px; 
                                            box-shadow: 0px 0px 10px 0px purple;
                                        }

                                    </style>

                                    <div class="table-responsive mt-2">
                                        <table class="table table-bordered table-striped table-hover" id="example2">
                                            <thead class="">
                                                <tr class="bg-pink text-white">
                                                    <th class="text-center ">CONSECUTIVO</th>
                                                    <th class="text-center ">FECHA</th>
                                                    <th class=" ">NOMBRE TERCERO</th>
                                                    <th class="text-center ">NUMERO FACTURA</th>
                                                    <th class=" ">CANTIDAD</th>
                                                    <th class="text-center ">DESCRIPCION</th>
                                                    <th class="text-center ">TOTAL</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $total = 0;
                                                $sql4 = "SELECT * FROM alm_compra ORDER BY fecha desc, id desc";
                                                $query4 = $conn->query($sql4);
                                                if ($query4->num_rows > 0) {
                                                    while ($row4 = $query4->fetch_assoc()) {
                                                        ?>
                                                        <tr class="align-middle" id="hover_enlace" 
                                                            style="cursor: pointer;"

                                                            onclick=" window.location = 'compra-detalle.php?id_compra=<?php echo $row4['id']; ?> ';">

                                                            <td class="text-center">
                                                                <strong class="text-dark"><?php echo $row4['numero_compra']; ?></strong><br>
                                                            </td>
                                                            <td>
                                                               <?php echo $row4['fecha']; ?>
                                                            </td>
                                                            <td class="">
                                                                <?php echo $row4['nombre_tercero']; ?>
                                                            </td> 
                                                            <td class="text-center">
                                                                <?php echo $row4['numero_factura']; ?>
                                                            </td>
                                                            <td class="text-center">
                                                                <?php
                                                                $sql5 = "SELECT SUM(cantidad) as cantidad FROM alm_compra_detalle WHERE id_compra='" . $row4['id'] . "'";
                                                                $query5 = $conn->query($sql5);
                                                                $row5 = $query5->fetch_assoc();

                                                                if (isset($row5['cantidad'])) {
                                                                    $cantidad = $row5['cantidad'];
                                                                } else {
                                                                    $cantidad = 0;
                                                                }
                                                                ?>

                                                                <?php echo $cantidad; ?>
                                                            </td>

                                                            <td class="" style="width: 20%;">
                                                                <?php echo $row4['observacion']; ?>
                                                            </td>
                                                            <td class="text-end">
                                                                <b class="text-secondary float-start">$</b><b><?php echo number_format($row4['total_compra'], 0); ?></b>
                                                            </td> 
                                                        </tr>
                                                        <?php
                                                        $total += $row4['total_compra'];
                                                    }
                                                }
                                                ?>
                                            </tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- end page content-->
                    </div>
                    <!--end page content wrapper-->




                    <?php echo include '../general/footer.php'; ?>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <?php echo include '../general/libreria-js.php'; ?>

        <script>
            //Tabla producto
            $(document).ready(function () {
                var table = $('#example2').DataTable({
                    lengthChange: false,
                    buttons: ['copy', 'excel', 'pdf', 'print'],
                    "order": false,
                });

                table.buttons().container()
                        .appendTo('#example2_wrapper .col-md-6:eq(0)');
            });

        </script>

    </body>
</html>